﻿using System;
using Curse.AddOns;

namespace Curse.Minecraft.Models
{
    public class MinecraftModLoaderFeed : FeedFile<MinecraftModLoaderIndex>
    {        
        public new const int Version = 10;
        private readonly int _gameID;
        public MinecraftModLoaderFeed() { }

        public MinecraftModLoaderFeed(int gameID)
        {            
            _gameID = gameID;
        }

        public override string RelativeFolderPath
        {
            get { return "modloaders/" + _gameID + "/v" + Version; }
        }

        public override string RelativeUrlPath
        {
            get
            {
                return "feed/" + RelativeFolderPath;                
            }
        }

        public override string FileName
        {
            get
            {
                return "modloaders.json.bz2";
            }
        }        
    }
}
