﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Runtime.Serialization;
using Curse.AddOns;

namespace Curse.Minecraft.Models
{
	public enum ModLoaderInstallMethod
	{
		ForgeInstaller = 1,
		ForgeJarInstall = 2
	}

	/// <summary>
	///     Note: Ordinal position is important in this enum, this determines the installation order for multiple modloaders.
	/// </summary>
	public enum ModLoaderType
	{
		Any = 0,
		Forge = 1,
		Cauldron = 2,
		LiteLoader = 3
	}

	[DataContract(Name = "ModLoader")]
	public class MinecraftModLoaderVersion
	{
		public int ID { get; set; }
		public int GameVersionID { get; set; }
		public int MinecraftGameVersionID { get; set; }
		public string ForgeVersion { get; set; }

		[DataMember]
		public string Name { get; set; }

		[DataMember]
		public ModLoaderType Type { get; set; }

		[DataMember]
		public string DownloadUrl { get; set; }

		[DataMember]
		public string Filename { get; set; }

		[DataMember]
		public ModLoaderInstallMethod InstallMethod { get; set; }

		[DataMember]
		public bool Latest { get; set; }

		[DataMember]
		public bool Recommended { get; set; }

		[DataMember]
		public bool Approved { get; set; }

		[DataMember]
		public DateTime LastModified { get; set; }

		[DataMember]
		public string MavenVersionString { get; set; }

		[DataMember]
		public string VersionJson { get; set; }

		[DataMember]
		public string LibrariesInstallLocation { get; set; }

		[DataMember]
		public string MinecraftVersion { get; set; }

        [DataMember]
        public string AdditionalFilesJson { get; set; }

	    public MinecraftModLoaderVersion()
	    {
	        
	    }

		public MinecraftModLoaderVersion(GameVersion version, MinecraftGameVersion minecraftVersion)
		{
			GameVersionID = version.ID;
			MinecraftGameVersionID = minecraftVersion.ID;
			Approved = false;
		}		
	}
}