﻿using System;
using System.Data.SqlClient;

namespace MinecraftService.Minecraft.Data
{
    public class GameVersion
    {
        public int ID { get; private set; }

        public string Name { get; set; }

        public GameVersion()
        {
            
        }

        private GameVersion(SqlDataReader reader)
        {
            ID = reader.GetInt32(0);
            Name = reader.GetString(6);
        }

        public void SaveToDatabase()
        {
            using (var conn = DatabaseHelper.GetConnection())
            {
                using (var command = conn.CreateCommand())
                {
                    command.Parameters.AddWithValue("@GameID", 432); // 432=Minecraft
                    command.Parameters.AddWithValue("@Status", (byte)3); // 3=Unapproved
                    command.Parameters.AddWithValue("@Name", Name);
                    command.Parameters.AddWithValue("@Slug", ConvertToSlug(Name));
                    command.Parameters.AddWithValue("@BreaksCompatibility", false); // Always false for Minecraft?

                    if (ID == 0)
                    {
                        command.CommandText = "INSERT INTO [GameVersion] (GameID,Status,Name,Slug,BreaksCompatibility,DateCreated,DateModified,DateReleased) OUTPUT INSERTED.ID VALUES (@GameID,@Status,@Name,@Slug,@BreaksCompatibility,GETUTCDATE(),GETUTCDATE(),GETUTCDATE())";
                        ID = (int)command.ExecuteScalar();
                    }
                    else
                    {
                        command.CommandText = "UPDATE [GameVersion] SET GameID=@GameID,Status=@Status,Name=@Name,Slug=@Slug,BreaksCompatibility=@BreaksCompatibility,DateCreated=GETUTCDATE(),DateModified=GETUTCDATE(),DateRelease=GETUTCDATE() WHERE ID = @ID";
                        command.Parameters.AddWithValue("@ID", ID);
                        command.ExecuteNonQuery();
                    }
                }
            }
        }

        private string ConvertToSlug(string input)
        {
            return input.ToLowerInvariant().Replace(".", "-").Replace(" ", "-");
        }

        public static GameVersion GetByNameAndType(string name, GameVersionType type)
        {
            using (var conn = DatabaseHelper.GetConnection())
            {
                using (var command = conn.CreateCommand())
                {
                    command.Parameters.AddWithValue("@Name", name);
                    command.Parameters.AddWithValue("@GameDependencyID", type == GameVersionType.Minecraft ? DBNull.Value : (object) (byte) type);
                    command.CommandText = "SELECT * FROM [GameVersion] WHERE GameID=432 AND Name=@Name AND GameDependencyID=@GameDependencyID";

                    using (var reader = command.ExecuteReader())
                    {
                        return reader.Read() ? new GameVersion(reader) : null;
                    }
                }
            }
        }
    }
}