﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Runtime.Serialization;

namespace MinecraftService.Minecraft.Data
{
    public enum ModLoaderInstallMethod
    {
        ForgeInstaller,
        ForgeJarInstall
    }

    /// <summary>
    ///     Note: Ordinal position is important in this enum, this determines the installation order for multiple modloaders.
    /// </summary>
    public enum ModLoaderType
    {
        Any = 0,
        Forge = 1,
        Cauldron = 2,
        LiteLoader = 3
    }

    [DataContract(Name = "ModLoader")]
    public class MinecraftModLoaderVersion
    {
        public int ID { get; private set; }
        public int GameVersionID { get; set; }
        public int MinecraftGameVersionID { get; set; }

        [DataMember]
        public string Name { get; set; }
        [DataMember]
        public ModLoaderType Type { get; set; }
        [DataMember]
        public string DownloadUrl { get; set; }
        [DataMember]
        public string Filename { get; set; }
        [DataMember]
        public ModLoaderInstallMethod InstallMethod { get; set; }
        [DataMember]
        public bool Latest { get; set; }
        [DataMember]
        public bool Recommended { get; set; }
        [DataMember]
        public bool Approved { get; set; }
        [DataMember]
        public DateTime LastModified { get; set; }
        [DataMember]
        public string MavenVersionString { get; set; }
        [DataMember]
        public string LibrariesInstallLocation { get; set; }

        // Requires a Join with MinecraftGameVersion
        [DataMember]
        public string MinecraftVersion { get; set; }

        private MinecraftModLoaderVersion(SqlDataReader reader)
        {
            ID = reader.GetInt32(0);
            GameVersionID = reader.GetInt32(1);
            MinecraftGameVersionID = reader.GetInt32(2);

            Name = reader.GetString(3);
            Type = (ModLoaderType) reader.GetByte(4);
            DownloadUrl = reader.GetString(5);
            Filename = reader.GetString(6);
            InstallMethod = (ModLoaderInstallMethod) reader.GetByte(7);
            Latest = reader.GetBoolean(8);
            Recommended = reader.GetBoolean(9);
            Approved = reader.GetBoolean(10);
            LastModified = GetUtcTime(reader.GetDateTime(11));
            MavenVersionString = reader.GetString(12);
            LibrariesInstallLocation = reader.GetString(13);
        }

        private static DateTime GetUtcTime(DateTime badTime)
        {
            return DateTime.SpecifyKind(badTime, DateTimeKind.Utc).ToUniversalTime();
        }

        public static MinecraftModLoaderVersion[] GetAll()
        {
            var modLoaders = new List<MinecraftModLoaderVersion>();
            using (var conn = new SqlConnection(""))
            {
                using (var command = conn.CreateCommand())
                {
                    command.CommandText = "SELECT ml.*,mv.VersionString FROM [ModLoader] as ml LEFT JOIN [MinecraftVersion] as mv ON ml.MinecraftVersionID = mv.ID";
                    using (var reader = command.ExecuteReader())
                    {
                        modLoaders.Add(new MinecraftModLoaderVersion(reader)
                        {
                            MinecraftVersion = (string) reader["VersionString"],
                        });
                    }
                }
            }

            return modLoaders.ToArray();
        }
    }
}