﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace MinecraftService.Minecraft.Polling
{
    public static class MCConstants
    {
        // Mojang
        //public const string MinecraftLauncherUrl = "https://s3.amazonaws.com/Minecraft.Download/launcher/Minecraft.exe";
        public const string MinecraftLauncherUrl = "https://launcher.mojang.com/download/Minecraft.exe";

        public const string MinecraftVersionListUrl =
            "http://s3.amazonaws.com/Minecraft.Download/versions/versions.json";

        public const string MinecraftVersionJarMask = "http://s3.amazonaws.com/Minecraft.Download/versions/{0}/{0}.jar";

        public const string MinecraftVersionJsonMask =
            "http://s3.amazonaws.com/Minecraft.Download/versions/{0}/{0}.json";

        public const string LauncherProfileFile = "launcher_profiles.json";

        public const string LauncherVersion = "1.0.1.0";
        public const string LauncherApplicationName = "Minecraft";
        public const string LauncherDefaultWrapper = "net.minecraft:launchwrapper:1.5";


        // Forge
        public const string ForgeGradleVersionListUrl =
            "http://minecraftforge.cursecdn.com/maven/net/minecraftforge/forge/json";

        public const string ForgeLegacyVersionListUrl = "http://minecraftforge.cursecdn.com/minecraftforge/json";

        public const string ForgeDownloadUrlMask =
            "http://minecraftforge.cursecdn.com/maven/net/minecraftforge/forge/{0}/{1}";

        public const string ForgeLibPath = "files.minecraftforge.net/maven";
        public const string CurseLibPath = "minecraftforge.cursecdn.com/maven2";
        public const string ForgeLegacyLibs_14 = "http://minecraftforge.cursecdn.com/fmllibs/fml_libs.zip";
        public const string ForgeLegacyLibs_15 = "http://minecraftforge.cursecdn.com/fmllibs/fml_libs15.zip";
        public const string ForgeLegacyLauncher = "net.curse:legacylauncher:1.2";
        public const string ForgeLegacyLauncherClass = "net.curse.launch.Launcher";
        public const string ForgeJarmodDirectory = "jarmods";

        // Client
        public const string RootDirectoryMask = @"{0}\Curse\Minecraft";
        public const string InstallDirectoryName = "Install";
        public const string InstanceDirectoryName = "Instances";
        public const string VersionDirectoryName = "versions";
        public const string LibraryDirectoryName = "libraries";
        public const string DownloadDirectoryName = "Downloads";
        public const string BackupDirectoryName = "Backups";


        public const string InstanceFolder_Mods = "mods";

        public const string InstanceFolder_Configs = "config";
        public const string InstanceFolder_JarMods = "jarmods";
        public const string InstanceFolder_CoreMods = "coremods";
        public const string InstanceFolder_ResourcePacks = "resourcepacks";
        public const string InstanceFolder_Maps = "saves";
        public const string InstanceFolder_Scripts = "scripts";

        public const string DisabledMask = ".disabled";


        public const string ManifestFilename = "manifest.json";
        public const string InstanceSettingsFilename = "instance.json";

        public const int DownloadTimeoutPeriod = 30000; // Download timeout in milliseconds
        public const int DownloadWaitInterval = 100; // Download polling interval in milliseconds

        // Java stuff

        // Magic Curse Forge IDs
        public const int MinecraftGameID = 432;
        public const int MinecraftModpackSectionID = 4471;
        public const int MinecraftModSectionID = 6;
        public const int MinecraftResourcePackSectionID = 12;
        public const int MinecraftMapsSectionID = 17;

        public static readonly string[] LibraryMirrors =
        {
            "http://minecraftforge.cursecdn.com/maven/",
            "http://mavencentral.cursecdn.com/maven2/", "https://repo1.maven.org/maven2/",
            "http://files.mincraftforge.com/maven/"
        };

        public static readonly string[] KnownJavaArgs = { "-Xmx", "-Xms" };

        // ReSharper restore InconsistentNaming
    }
}