﻿using System;
using System.Net;

namespace MinecraftService
{
    public class WebClientWithTimeout : WebClient
    {
        private int _timeout = 1000 * 10; // 10 Seconds;
        private string _userAgent = null;

        public int Timeout
        {
            get
            {
                return _timeout;
            }
            set
            {
                _timeout = value;
            }
        }



        public string UserAgent
        {
            get
            {
                return _userAgent;
            }
            set
            {
                _userAgent = value;
            }
        }

        public WebClientWithTimeout(int timeoutInSeconds)
        {
            Timeout = timeoutInSeconds * 1000;
        }
        public WebClientWithTimeout(int timeoutInSeconds, string useragent)
        {
            Timeout = timeoutInSeconds * 1000;
            UserAgent = useragent;
        }

        protected override WebRequest GetWebRequest(Uri address)
        {
            WebRequest request = base.GetWebRequest(address);
            request.Timeout = Timeout;
            if (UserAgent != null)
            {
                (request as HttpWebRequest).UserAgent = UserAgent;
            }
            return request;
        }

    }
}