﻿using System.Runtime.Serialization;
using Curse.RewardPointsService;

namespace Curse.RewardPointsService.Faults
{
    [DataContract]
    public class RewardFault
    {
        [DataMember]
        public PointFaultCode Code { get; set; }

        [DataMember]
        public string Message { get; set; }
    }

    public enum PointFaultCode
    {
        NotEnoughBounsPoints = 100,
        UserNotInRewardProgram = 101,
        RefundedWithDifferentAmount = 200,
        RefundedAlready = 201,
        OrderUserFoundWithDiferentAmount = 202,
        OrderUserComboNotFound = 203,
        RefundPointsNotPositive = 204,
        UserDoesNotHaveEnoughPoints = 300,
        OrderAlreadyCompleted = 301,
        OrderAlreadyCompletedDifferentAmount = 302,
        OrderAlreadyCompletedDifferentUser = 303,
        SpendPointsNotnegative = 304,
        UserNotEnoughPointsToTranfer = 400,
        RecipientNotEligeble = 401,
        TransferPointsNotPositive = 402,
        NegativeBudget = 600,
        TransactionSqlError = 900,
        GeneralSqlError = 901,
        GeneralException = 1000
    }
}