﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Web;
using Curse.RewardPointsService.Enums;
using Curse.RewardPointsService.Enums;
using Curse.RewardPointsService.Extensions;
using Curse.RewardPointsService.Models;
using Curse.RewardPointsService.Faults;

namespace Curse.RewardPointsService
{
    // NOTE: You can use the "Rename" command on the "Refactor" menu to change the interface name "IService1" in both code and config file together.
    [ServiceKnownType(typeof(TransactionType))]
    [ServiceKnownType(typeof(RecordGenerationBreakdown))]
    [ServiceContract(Namespace = "http://rewardpointsservice.curse.local")]
    public interface IRewardPointsService
    {

        [OperationContract]
        //[RequireApiKey("x-api-key", "XApiKey")]
        [WebGet(UriTemplate = "/getuserpoints?userid={userID}")]
        int GetUserPoints(int userID);

        [OperationContract]
        //[RequireApiKey("x-api-key", "XApiKey")]
        [WebGet(UriTemplate = "getuserpointtransactions?userid={userID}&page={page}&recordsperpage={recordsPerPage}")]
        RewardPointTransactions GetUserTransactions(int userID, int page, int recordsPerPage);

        [OperationContract]
        //[RequireApiKey("x-api-key", "XApiKey")]
        [FaultContract(typeof(RewardFault))]
        [WebGet(UriTemplate = "setmonthlypremiumbudget?month={month}&budget={budget}")]
        bool SetMonthlyPremiumBudget(DateTime month, decimal budget);

        [OperationContract]
        //[RequireApiKey("x-api-key", "XApiKey")]
        [WebGet(UriTemplate = "/getmonthlybudgets?page={page}&recordsperpage={recordsPerPage}")]
        MonthlyBudgets GetMonthlyBudgets(int page, int recordsPerPage);

        [OperationContract]
        //[RequireApiKey("x-api-key", "XApiKey")]
        [FaultContract(typeof(RewardFault))]
        [WebGet(UriTemplate = "/spendpoints?userid={userID}&amount={amount}&orderid={orderID}")]
        bool SpendPoints(int userID, decimal amount, int orderID);

        [OperationContract]
        //[RequireApiKey("x-api-key", "XApiKey")]
        [FaultContract(typeof(RewardFault))]
        [WebGet(UriTemplate = "/refundpoints?userid={userID}&amount={amount}&orderid={orderID}")]
        bool RefundPoints(int userID, decimal amount, int orderID);

        [OperationContract]
        //[RequireApiKey("x-api-key", "XApiKey")]
        [FaultContract(typeof(RewardFault))]
        [WebGet(UriTemplate = "/transferpoints?senduserid={sendUserID}&recipientuserid={recipientUserID}&amounttogive={amountToGive}")]
        bool TransferPoints(int senderUserID, int recipientUserID, decimal amountToGive);

        [OperationContract]
        //[RequireApiKey("x-api-key", "XApiKey")]
        [WebGet(UriTemplate = "/getbonuspoints")]
        Decimal GetBonusPoints();

        [OperationContract]
        //[RequireApiKey("x-api-key", "XApiKey")]
        [FaultContract(typeof(RewardFault))]
        [WebGet(UriTemplate = "/awardbonuspoints?userid={userID}&amount={amount}")]
        bool AwardBonusPoints(int userID, decimal amount);


        [OperationContract]
        //[RequireApiKey("x-api-key", "XApiKey")]
        [WebGet(UriTemplate = "/addprojecttoblacklist?projectid={projectID}")]
        bool AddProjectToBlacklist(int projectID);

        [OperationContract]
        //[RequireApiKey("x-api-key", "XApiKey")]
        [WebGet(UriTemplate = "/removeprojectfromblacklist?projectid={projectID}")]
        bool RemoveProjectFromBlacklist(int projectID);

        [OperationContract]
        //[RequireApiKey("x-api-key", "XApiKey")]
        [WebGet(UriTemplate = "/getpointexchangerate")]
        Decimal GetPointExchangeRate();

        [OperationContract]
        //[RequireApiKey("x-api-key", "XApiKey")]
        [WebGet(UriTemplate = "/getgenerationbreakdown?recordid={recordID}")]
        RecordGenerationBreakdowns GetGenerationBreakdown(int recordID);

        [OperationContract]
        //[RequireApiKey("x-api-key", "XApiKey")]
        [WebGet(UriTemplate = "/getcountusertransactions?userid={userID}")]
        int GetCountUserTransactions(int userID);

    }


    [Serializable]
    [CollectionDataContract]
    [KnownType(typeof(Record))]
    public class RewardPointTransactions : List<Record>
    { }


    [Serializable]
    [CollectionDataContract]
    [KnownType(typeof(MonthlyBudget))]
    public class MonthlyBudgets : List<MonthlyBudget>
    { }

    [Serializable]
    [CollectionDataContract]
    [KnownType(typeof(RecordGenerationBreakdown))]
    public class RecordGenerationBreakdowns : List<RecordGenerationBreakdown>
    { }

}
