﻿using System;
using System.Data.SqlClient;
using System.Runtime.Serialization;

namespace Curse.RewardPointsService.Models
{
    [Serializable]
    [DataContract]
    public class DailyBudget
    {
        [DataMember]
        public int ID { get; set; }
        [DataMember]
        public DateTime DailyBudgetDate { get; set; }
        [DataMember]
        public int MonthlyBudgetID { get; set; }
        [DataMember]
        public DateTime DateCreated { get; set; }
        [DataMember]
        public DateTime DateModified { get; set; }
        [DataMember]
        public decimal AddonPercentage { get; set; }
        [DataMember]
        public decimal LibraryPercentage { get; set; }
        [DataMember]
        public decimal BonusPercentage { get; set; }
        [DataMember]
        public decimal DailyPermiumBudget { get; set; }
        [DataMember]
        public decimal DailyPoints { get; set; }
        [DataMember]
        public decimal Fairness { get; set; }
        [DataMember]
        public int LibraryThreshold { get; set; }
        [DataMember]
        public int PopularityThreshold { get; set; }

        public void SetFromDataReader(SqlDataReader reader)
        {
            ID = reader.GetInt32(reader.GetOrdinal("ID"));
            DailyBudgetDate = reader.GetDateTime(reader.GetOrdinal("DailyBudgetDate"));
            MonthlyBudgetID = reader.GetInt32(reader.GetOrdinal("MonthlyBudgetID"));
            DateCreated = reader.GetDateTime(reader.GetOrdinal("DateCreated"));
            DateModified = reader.GetDateTime(reader.GetOrdinal("DateModified"));
            AddonPercentage = reader.GetDecimal(reader.GetOrdinal("AddonPercentage"));
            LibraryPercentage = reader.GetDecimal(reader.GetOrdinal("LibraryPercentage"));
            BonusPercentage = reader.GetDecimal(reader.GetOrdinal("BonusPercentage"));
            DailyPermiumBudget = reader.GetDecimal(reader.GetOrdinal("DailyPermiumBudget"));
            DailyPoints = reader.GetDecimal(reader.GetOrdinal("DailyPoints"));
            Fairness = reader.GetDecimal(reader.GetOrdinal("Fairness"));
            PopularityThreshold = reader.GetInt32(reader.GetOrdinal("PopularityThreshold"));
        }
    }
}