﻿using System.Data.SqlClient;

namespace Curse.RewardPointsService.Models
{
    public class ProjectReward
    {

        public int ID { get; set; }
        public int DailyBudgetID { get; set; }
        public int ProjectID { get; set; }
        public bool Islibrary { get; set; }

        public decimal RewardedPoints { get; set; }
        public decimal Popularity { get; set; }
        public decimal LibraryPopularity { get; set; }
        public decimal PopularityScore { get; set; }

        public void SetFromDataReader(SqlDataReader reader)
        {
            ID = reader.GetInt32(reader.GetOrdinal("ID"));
            DailyBudgetID = reader.GetInt32(reader.GetOrdinal("DailyBudgetID"));
            ProjectID = reader.GetInt32(reader.GetOrdinal("ProjectID"));
            Islibrary = reader.GetBoolean(reader.GetOrdinal("Islibrary"));

            RewardedPoints = reader.GetDecimal(reader.GetOrdinal("RewardedPoints"));
            LibraryPopularity = reader.GetDecimal(reader.GetOrdinal("LibraryPopularity"));
            PopularityScore = reader.GetDecimal(reader.GetOrdinal("PopularityScore"));
        }
    }
}