﻿using System.Data.SqlClient;

namespace Curse.RewardPointsService.Models
{
    public class RewardProgram
    {
        public int ID { get; set; }
        public decimal BonusPoints { get; set; }
        public decimal Fairness { get; set; }
        public int LibraryThreshold { get; set; }

        public decimal AddonPercentage { get; set; }
        public decimal LibraryPercentage { get; set; }
        public int PopularityThreshold { get; set; }
        public decimal EcpmImpressionsModifier { get; set; }
        public decimal EcpmRevenueModifier { get; set; }
        public decimal EcpmBudgetShareModifier { get; set; }
        public decimal EstimatePremiumBudgetDefault { get; set; }
        public decimal PointExchangeRate { get; set; }
        public decimal EstimatedPremiumBudgetTrendModifier { get; set; }
        //public decimal  { get; set; }


        public void SetFromDataReader(SqlDataReader reader)
        {
            ID = reader.GetInt32(reader.GetOrdinal("ID"));
            BonusPoints = reader.GetDecimal(reader.GetOrdinal("BonusPoints"));
            Fairness = reader.GetDecimal(reader.GetOrdinal("Fairness"));
            LibraryThreshold = reader.GetInt32(reader.GetOrdinal("LibraryThreshold"));
            AddonPercentage = reader.GetDecimal(reader.GetOrdinal("AddonPercentage"));
            LibraryPercentage = reader.GetDecimal(reader.GetOrdinal("LibraryPercentage"));
            PopularityThreshold = reader.GetInt32(reader.GetOrdinal("PopularityThreshold"));
            EcpmImpressionsModifier = reader.GetDecimal(reader.GetOrdinal("EcpmImpressionsModifier"));
            EcpmRevenueModifier = reader.GetDecimal(reader.GetOrdinal("EcpmRevenueModifier"));
            EcpmBudgetShareModifier = reader.GetDecimal(reader.GetOrdinal("EcpmBudgetShareModifier"));
            EstimatePremiumBudgetDefault = reader.GetDecimal(reader.GetOrdinal("EstimatePremiumBudgetDefault"));
            PointExchangeRate = reader.GetDecimal(reader.GetOrdinal("PointExchangeRate"));
            EstimatedPremiumBudgetTrendModifier = reader.GetDecimal(reader.GetOrdinal("EstimatedPremiumBudgetTrendModifier"));
        }
    }
}