﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Curse.ROM
{
    public sealed class Player
         : IPackable
    {
        public String Name;
        public String MainClass;
        public String SubClass;
        public Int32 MainClassLevel;
        public Int32 SubClassLevel;
        public Byte Sex;
        public String Server;
        public Int32 MainXP;
        public Int32 MainXPLimit;
        public Int32 SubXP;
        public Int32 SubXPLimit;
        public String GuildName;
        public PackableList<PlayerEquipment> Equipment = new PackableList<PlayerEquipment>();
        public PackableList<ProfileStat> Stats = new PackableList<ProfileStat>();
        public PackableList<ProfileSkill> Skills = new PackableList<ProfileSkill>();
        public PackableList<ProfileSkill> TradeSkills = new PackableList<ProfileSkill>();
        public PackableList<RecipeEntry> Recipes = new PackableList<RecipeEntry>();

        public Boolean Write(IWriteable pBuf)
        {
            return false;
        }

        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref Name) &&
                   pBuf.Read(ref Server) &&
                   pBuf.Read(ref Sex) &&
                   pBuf.Read(ref MainClass) &&
                   pBuf.Read(ref SubClass) &&
                   pBuf.Read(ref MainClassLevel) &&
                   pBuf.Read(ref SubClassLevel) &&
                   pBuf.Read(ref MainXP) &&
                   pBuf.Read(ref MainXPLimit) &&
                   pBuf.Read(ref SubXP) &&
                   pBuf.Read(ref SubXPLimit) &&
                   pBuf.Read(ref GuildName) &&
                   Equipment.Read(pBuf) &&
                   Stats.Read(pBuf) &&
                   Skills.Read(pBuf) &&
                   TradeSkills.Read(pBuf) &&
                   Recipes.Read(pBuf);
        }
    }
}
