﻿using Curse;
using Curse.ROM;
using System;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
namespace ROMDataService
{
    public static partial class DBItems
    {

        private static Dictionary<CustomKey, Int32> sEquipItems = new Dictionary<CustomKey, Int32>(new CustomKey.CustomKeyComparer());
        private static DataTable sItemUpdateSchema = null;
        private static String sUpdateQuery = null;


        //since the only item data we need to deal with is sources, keep them in this form
        private static Dictionary<int, int> sItemSources = new Dictionary<int, int>();


        private static String[] sUpdateIgnoredColumns = { "id","name_en","version_id","req_level" };
        private static String[] sIgnoreInsertColumns = { };
        private static Dictionary<String, String> sUpdateCustomColumns = new Dictionary<string, string>();

        public static void AddSource(int item, byte source)
        {
            if (sItemSources.ContainsKey(item))
            {
                int current = sItemSources[item];
                Utility.AddBitValue(ref current ,source);
                sItemSources[item] = current;
            }
            else
            {
                int current = 0;
                Utility.AddBitValue(ref current, source);
                sItemSources[item] = (int)current;
            }
        }

        public static void Initialize()
        {

            using (SqlConnection conn = new SqlConnection(Config.Instance.ConnectionString))
            {
                conn.Open();
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select id,name_en, req_level from item";
                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        CustomKey key = new CustomKey(reader["name_en"], reader["req_level"]);
                        if (!sEquipItems.ContainsKey(key))
                        {
                            sEquipItems.Add(key, (int)reader["id"]);
                        }
                    }
                }
            }



            DB.LoadSchema(ref sItemUpdateSchema, "item");



            sUpdateQuery = "update item set ";
            sUpdateQuery = sUpdateQuery + DB.GetUpdateSQL(sItemUpdateSchema, sUpdateIgnoredColumns, sUpdateCustomColumns);
            sUpdateQuery = sUpdateQuery + " FROM item ,#item  tmp" +
                " WHERE item .id=tmp.id;";
        }

        public static Int32 GetEquipItemID(CustomKey key)
        {
            if (sEquipItems.ContainsKey(key))
            {
                return sEquipItems[key];
            }
            return 0;
        }

        public static void Save(Update pUpdate, SqlConnection pConn)
        {
            foreach (MallItem mitem in pUpdate.MallItems)
            {
                Int32 itemid = GetEquipItemID(new CustomKey(mitem.Name, 1));
                if (itemid > 0)
                {
                    AddSource(itemid, (byte)EItemSource.ItemShop);
                }
            }
            if (sItemSources.Count == 0)
            {
                return;
            }

            StringBuilder sql = new StringBuilder();
            DataRow dr = null;
            DataTable dtUpdate = sItemUpdateSchema.Clone();

            dtUpdate.BeginLoadData();

            CustomKey key;
            String locale = pUpdate.Language.ToString();
            SqlCommand cmd = pConn.CreateCommand();



            foreach (KeyValuePair<int, int> kvp in sItemSources)
            {
                dr = dtUpdate.NewRow();
                dr["id"] = kvp.Key;
                dr["source_id"] = kvp.Value;
                dr["updated"] = DateTime.UtcNow;
                dr["version_id"] = pUpdate.ClientVersion.Value;
                dtUpdate.Rows.Add(dr);
            }

            foreach (MallItem mitem in pUpdate.MallItems)
            {
                Int32 itemid = GetEquipItemID(new CustomKey(mitem.Name, 1));
                foreach (DataRow dr2 in dtUpdate.Rows)
                {
                    if ((int)dr2["id"] == itemid)
                    {
                        dr2["diamond_cost"] = mitem.Diamonds;
                    }
                }
            }




            if (dtUpdate.Rows.Count > 0)
            {

                cmd.CommandText = "SELECT TOP 0 * INTO #item FROM item;";
                cmd.ExecuteNonQuery();

                using (SqlBulkCopy bulkUpdate = new SqlBulkCopy(pConn,
                                                   SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                   null))
                {
                    bulkUpdate.BatchSize = 5000;
                    bulkUpdate.DestinationTableName = "#item";
                    bulkUpdate.WriteToServer(dtUpdate);
                    bulkUpdate.Close();
                }

                cmd.CommandText = String.Format(sUpdateQuery, locale);
                cmd.ExecuteNonQuery();
                cmd.CommandText = "DROP TABLE #item;";
                cmd.ExecuteNonQuery();
            }




        }

        

    }
}
