﻿using Curse;
using Curse.ROM;
using System;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.Data;
using System.Linq;
namespace ROMDataService
{
    public static partial class DBPlayers
    {
        private const Byte NUM_TRADESKILLS = 2;
        private const Byte NUM_STATS = 21;

        private static String sUpdateQuery = null;
        private static String sInsertQuery = null;

        private static Dictionary<CustomKey, Int32> sPlayerNameToId = new Dictionary<CustomKey, Int32>(new CustomKey.CustomKeyComparer());

        // Removed the owner id from here: "owner_id", for now.
        private static String[] sUpdateIgnoredColumns = { "id", "name", "server_id", "posted" };
        private static String[] sIgnoreInsertColumns = { "id" };

        private static Dictionary<String, String> sUpdateCustomColumns = new Dictionary<string, string>();
        private static Dictionary<String,Dictionary<String, int>> sClassLookup = new Dictionary<String,Dictionary<string, int>>();



        private static String sTempTableCreation = "SELECT TOP 0 * INTO #player FROM player;ALTER TABLE #player DROP COLUMN id;ALTER TABLE #player ADD id int;";
        private static DataTable sPlayerUpdateSchema = null;
        private static DataTable sPlayerInsertSchema = null;
        private static DataTable sPlayerEquipmentSchema = null;
        private static DataTable sPlayerSkillsSchema = null;
        private static DataTable sPlayerTradeskillsSchema = null;
        private static DataTable sPlayerRecipesSchema = null;

        private static Dictionary<int, String> profileStatFieldMapping = new Dictionary<int, String>();


        public static void Initialize()
        {
            sUpdateCustomColumns.Clear();
            sPlayerNameToId.Clear();

            PopulatePlayerNameToID();
            sClassLookup["en"] = new Dictionary<string, int>();
            sClassLookup["en"].Add("Warrior", 1);
            sClassLookup["en"].Add("Scout", 2);
            sClassLookup["en"].Add("Rogue", 3);
            sClassLookup["en"].Add("Mage", 4);
            sClassLookup["en"].Add("Priest", 5);
            sClassLookup["en"].Add("Knight", 6);
            sClassLookup["en"].Add("Warden", 7);
            sClassLookup["en"].Add("Druid", 8);

            sClassLookup["de"] = new Dictionary<string, int>();
            sClassLookup["de"].Add("Krieger", 1);
            sClassLookup["de"].Add("Kundschafter", 2);
            sClassLookup["de"].Add("Schurke", 3);
            sClassLookup["de"].Add("Magier", 4);
            sClassLookup["de"].Add("Priestier", 5);
            sClassLookup["de"].Add("Ritter", 6);
            sClassLookup["de"].Add("Bewahrer", 7);
            sClassLookup["de"].Add("Druide", 8);

            profileStatFieldMapping.Add(12, "attack");
            profileStatFieldMapping.Add(13, "defense");
            profileStatFieldMapping.Add(14, "magic_defense");
            profileStatFieldMapping.Add(15, "magic_attack");
            profileStatFieldMapping.Add(2, "strength");
            profileStatFieldMapping.Add(3, "stamina");
            profileStatFieldMapping.Add(27, "earth_res");
            profileStatFieldMapping.Add(28, "water_res");
            profileStatFieldMapping.Add(29, "fire_res");
            profileStatFieldMapping.Add(30, "wind_res");
            profileStatFieldMapping.Add(31, "light_res");
            profileStatFieldMapping.Add(32, "dark_res");
            profileStatFieldMapping.Add(4, "intelligence");
            profileStatFieldMapping.Add(5, "wisdom");
            profileStatFieldMapping.Add(6, "dexterity");
            profileStatFieldMapping.Add(200, "melee_damage");
            profileStatFieldMapping.Add(201, "melee_off_damage");
            profileStatFieldMapping.Add(202, "melee_crit");
            profileStatFieldMapping.Add(203, "ranged_damage");
            profileStatFieldMapping.Add(204, "ranged_attack");
            profileStatFieldMapping.Add(205, "ranged_crit");
            profileStatFieldMapping.Add(206, "parry");
            profileStatFieldMapping.Add(207, "magic_damage");
            profileStatFieldMapping.Add(208, "magic_crit");
            profileStatFieldMapping.Add(209, "magic_heal");

            DB.LoadSchema(ref sPlayerUpdateSchema, "#player", sTempTableCreation);
            DB.LoadSchema(ref sPlayerInsertSchema, "player");
            DB.LoadSchema(ref sPlayerEquipmentSchema, "player_equipment");
            DB.LoadSchema(ref sPlayerSkillsSchema, "player_skills");
            DB.LoadSchema(ref sPlayerTradeskillsSchema, "player_tradeskills");
            DB.LoadSchema(ref sPlayerRecipesSchema, "player_recipes");


            sInsertQuery = DB.GetInsertSQL(sPlayerInsertSchema, sIgnoreInsertColumns);

            sUpdateQuery = "update player set ";
            sUpdateQuery = sUpdateQuery + DB.GetUpdateSQL(sPlayerUpdateSchema, sUpdateIgnoredColumns, sUpdateCustomColumns);
            sUpdateQuery = sUpdateQuery + " FROM player,#player tmp" +
                " WHERE player.id=tmp.id;";

        }

        public static Int32 GetClass(String className, String lang)
        {
            if(!sClassLookup.ContainsKey(lang))
            {
                return 0;
            }
            if (sClassLookup[lang].ContainsKey(className))
            {
                return sClassLookup[lang][className];
            }
            return 0;
        }

        private static void PopulatePlayerNameToID()
        {
            String query = "select id, server_id, name from player with(nolock)";

            Int32 id;
            Int32 serverId;
            Int32 count = 0;
            using (SqlConnection conn = new SqlConnection(Config.Instance.ConnectionString))
            {
                conn.Open();

                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = query;
                using (SqlDataReader dr = cmd.ExecuteReader())
                {
                    while (dr.Read())
                    {
                        AddPlayer((String)dr[2], (Int32)dr[1], (Int32)dr[0]);
                        ++count;
                    }
                }
            }
            Logger.Log(ELogLevel.Debug,
                       null,
                       "Populated {0} names from table player",
                       count);
        }

        public static Int32 GetPlayerId(String pPlayerName, Int32 pServerId)
        {
            CustomKey key = new CustomKey(pPlayerName, pServerId);
            return DB.GetIdFromName(sPlayerNameToId, key);
        }

        public static void AddPlayer(String pPlayerName, Int32 pServerId, Int32 pPlayerId)
        {
            CustomKey key = new CustomKey(pPlayerName, pServerId);
            DB.AddNameFromId(sPlayerNameToId, key, pPlayerId);
        }



        public static void Save(Update pUpdate, SqlConnection pConn)
        {

            if (pUpdate.Players.Count == 0)
            {
                return;
            }

            DataRow dr = null;
            DataTable dtUpdate = sPlayerUpdateSchema.Clone();
            DataTable dtInsert = sPlayerInsertSchema.Clone();
            DataTable dtEquipmentInsert = sPlayerEquipmentSchema.Clone();
            DataTable dtSkillInsert = sPlayerSkillsSchema.Clone();
            DataTable dtTradeskillInsert = sPlayerTradeskillsSchema.Clone();
            DataTable dtRecipeInsert = sPlayerRecipesSchema.Clone();


            dtUpdate.BeginLoadData();
            dtEquipmentInsert.BeginLoadData();
            dtSkillInsert.BeginLoadData();
            dtTradeskillInsert.BeginLoadData();
            dtRecipeInsert.BeginLoadData();


            String locale = pUpdate.Language.ToString();

            SqlCommand cmd = pConn.CreateCommand();


            bool isNewRow = false;
            Int32 playerId = 0;
            Int32 serverId = DBServers.GetServerId(pUpdate.ServerName);
            String deleteIds = "";
            String sql = "";
            Int32 guildId = 0;

            foreach (Player player in pUpdate.Players)
            {
                playerId = GetPlayerId(player.Name, serverId);

                isNewRow = playerId <= 0;
                if (isNewRow)
                {
                    dr = dtInsert.NewRow();
                }
                else
                {
                    dr = dtUpdate.NewRow();
                    dr["id"] = playerId;
                }

                dr["name"] = player.Name;
                dr["main_level"] = player.MainClassLevel;
                dr["sub_level"] = player.SubClassLevel;
                if (player.Sex == 0)
                {
                    dr["gender"] = 0;
                }
                else
                {
                    dr["gender"] = 1;
                }
                dr["gender"] = player.Sex;
                dr["server_id"] = DBServers.GetServerId(player.Server);
                dr["owner_id"] = pUpdate.UserId;
                dr["main_class"] = GetClass(player.MainClass, pUpdate.Language);
                if ((int)dr["main_class"] == 0)
                {
                    continue;
                }
                dr["main_xp"] = player.MainXP;
                dr["main_xp_max"] = player.MainXPLimit;
                dr["sub_xp"] = player.SubXP;
                dr["sub_xp_max"] = player.SubXPLimit;
                dr["guild_id"] = DBGuilds.GetGuildId(player.GuildName, (int)dr["server_id"]);
                //dr["hp"] = player.HP;
                //dr["mp"] = player.MP;
                dr["sub_class"] = GetClass(player.SubClass, pUpdate.Language);

                foreach (ProfileStat stat in player.Stats)
                {
                    if (profileStatFieldMapping.ContainsKey(stat.StatID))
                    {
                        dr["stat_" + profileStatFieldMapping[stat.StatID]] = stat.StatValue;
                    }
                }

                

                // Meta Data

                dr["posted"] = DateTime.UtcNow;
                dr["updated"] = DateTime.UtcNow;

                if (isNewRow)
                {
                    cmd.CommandText = DB.GetFilledInsertSQL(sInsertQuery, sPlayerInsertSchema, dr, sIgnoreInsertColumns, locale);
                    playerId = (Int32)cmd.ExecuteScalar();
                    AddPlayer(player.Name, serverId, playerId);
                }
                else
                {
                    dtUpdate.Rows.Add(dr);
                }

                deleteIds += "," + playerId;

                foreach (PlayerEquipment equipment in player.Equipment)
                {
                    DataRow equipmentRow = dtEquipmentInsert.NewRow();
                    equipmentRow["player_id"] = playerId;
                    equipmentRow["slot_id"] = equipment.Slot;
                    equipmentRow["item_id"] = DBItems.GetEquipItemID(new CustomKey(equipment.Name.Trim(), equipment.Level));
                    //equipmentRow["item_id"] = DBItems.GetEquipItemID(new CustomKey(equipment.Name.Trim(),equipment.Level),pUpdate.Language);
                    equipmentRow["item_text"] = equipment.TooltipText;

                    if ((int)equipmentRow["item_id"] > 0)
                    {
                        dtEquipmentInsert.Rows.Add(equipmentRow);
                    }

                }

                foreach (RecipeEntry recipe in player.Recipes)
                {
                    DataRow recipeRow = dtRecipeInsert.NewRow();
                    recipeRow["player_id"] = playerId;
                    recipeRow["recipe_id"] = recipe.RecipeID;
                    dtRecipeInsert.Rows.Add(recipeRow);
                }

                foreach (ProfileSkill skill in player.Skills)
                {
                    DataRow skillRow = dtSkillInsert.NewRow();
                    skillRow["player_id"] = playerId;
                    skillRow["skill_id"] = skill.SkillID;
                    skillRow["skill_level"] = skill.SkillValue;
                    skillRow["skill_max"] = skill.SkillMax;
                    dtSkillInsert.Rows.Add(skillRow);
                }

                foreach (ProfileSkill skill in player.TradeSkills)
                {
                    DataRow skillRow = dtTradeskillInsert.NewRow();
                    skillRow["player_id"] = playerId;
                    skillRow["skill_id"] = skill.SkillID;
                    skillRow["skill_level"] = skill.SkillValue;
                    skillRow["skill_max"] = skill.SkillMax;
                    dtTradeskillInsert.Rows.Add(skillRow);
                }

                

            }

            if (deleteIds.Length > 0)
            {
                sql += "delete from player_equipment where player_id in(" + deleteIds.Substring(1) + ");delete from player_skills where player_id in(" + deleteIds.Substring(1) + ");delete from player_tradeskills where player_id in(" + deleteIds.Substring(1) + ");delete from player_recipes where player_id in(" + deleteIds.Substring(1) + ");";
            }


            cmd.CommandText = sql;
            cmd.ExecuteNonQuery();

            if (dtEquipmentInsert.Rows.Count > 0)
            {
                using (SqlBulkCopy bulk = new SqlBulkCopy(pConn,
                                   SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                   null))
                {
                    bulk.DestinationTableName = "player_equipment";
                    bulk.BatchSize = 5000;
                    bulk.WriteToServer(dtEquipmentInsert);
                    bulk.Close();
                }
            }

            if (dtRecipeInsert.Rows.Count > 0)
            {
                using (SqlBulkCopy bulk = new SqlBulkCopy(pConn,
                                   SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                   null))
                {
                    bulk.DestinationTableName = "player_recipes";
                    bulk.BatchSize = 5000;
                    bulk.WriteToServer(dtRecipeInsert);
                    bulk.Close();
                }
            }


            if (dtSkillInsert.Rows.Count > 0)
            {
                using (SqlBulkCopy bulk = new SqlBulkCopy(pConn,
                                   SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                   null))
                {
                    bulk.DestinationTableName = "player_skills";
                    bulk.BatchSize = 5000;
                    bulk.WriteToServer(dtSkillInsert);
                    bulk.Close();
                }
            }

            if (dtTradeskillInsert.Rows.Count > 0)
            {
                using (SqlBulkCopy bulk = new SqlBulkCopy(pConn,
                                   SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                   null))
                {
                    bulk.DestinationTableName = "player_tradeskills";
                    bulk.BatchSize = 5000;
                    bulk.WriteToServer(dtTradeskillInsert);
                    bulk.Close();
                }
            }

            

            if (dtUpdate.Rows.Count > 0)
            {
                cmd.CommandText = sTempTableCreation;
                cmd.ExecuteNonQuery();
                using (SqlBulkCopy bulk = new SqlBulkCopy(pConn,
                                                  SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                  null))
                {
                    bulk.BatchSize = 5000;
                    bulk.DestinationTableName = "#player";
                    bulk.WriteToServer(dtUpdate);
                    bulk.Close();
                }

                cmd.CommandText = sUpdateQuery;
                cmd.ExecuteNonQuery();
                cmd.CommandText = "DROP TABLE #player;";
                cmd.ExecuteNonQuery();
            }
        }

    }
}


