﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.ServiceModels.Caching;
using Curse.ServiceModels.Configuration;
using System.Data.SqlClient;
using Curse.ServerModService.Models;
using Curse.Extensions;

namespace Curse.ServerModService.Caching
{
    public class ServerModFileCache : IncrementalCache<ServerModFile>
    {
        private static readonly ServerModFileCache _instance = new ServerModFileCache();
        public static ServerModFileCache Instance { get { return _instance; } }

        public ServerModFileCache() : base("Radon", "spGetServerModFiles") { }

        public override bool UpdateCache()
        {
            if (!base.UpdateCache())
            {
                return false;
            }
            return true;
        }

        public List<ServerModFile> GetFilesByIDs(List<int> ids)
        {
            var serverModFiles = new List<ServerModFile>();
            foreach (var projectId in ids.Distinct())
            {
                serverModFiles.AddRange(this.CacheData.Where(p => p.ServerModId == projectId));
            }
            return serverModFiles.ToList();
        }
    }
}