﻿using System;
using Curse.ServiceModels.Caching;
using System.Data.SqlClient;
using System.Runtime.Serialization;
using System.Collections.Generic;

namespace Curse.ServerModService.Models
{
    [DataContract]
    public class ServerMod : ICachable
    {
        [DataMember(Name = "id")]
        public int ID { get; set; }

        [DataMember(Name = "slug")]
        public string Slug { get; set; }

        [DataMember(Name = "stage")]
        public string Stage { get; set; }

        [DataMember(Name = "name")]
        public string Name { get; set; }

        public void SetFromDataReader(SqlDataReader reader)
        {
            this.ID = reader.GetInt32(reader.GetOrdinal("ID"));
            this.Slug = reader.GetString(reader.GetOrdinal("Slug"));
            var name = Enum.GetName(typeof(EStatus), (EStatus)reader.GetByte(reader.GetOrdinal("Stage")));
            if (name != null) this.Stage = name.ToLower();
            this.Name = reader.GetString(reader.GetOrdinal("Name"));
        }
    }
}