﻿using System;
using System.Runtime.Serialization;
using Curse.ServiceModels.Caching;
using System.Data.SqlClient;
using Curse.Extensions;

namespace Curse.ServerModService.Models
{
    
    [DataContract]
    public class ServerModFile : ICachable
    {
        private readonly string _mediaFileUrl = System.Configuration.ConfigurationManager.AppSettings["downloadUrl"];

        public int ID { get; set; }

        [DataMember(Name = "projectId")]
        public int ServerModId { get; set; }

        [DataMember(Name = "gameVersion")]
        public string GameVersion { get; set; }

        [DataMember(Name = "fileName")]
        public string FileName { get; set; }
        
        [DataMember(Name = "name")]
        public string Name { get; set; }

        [DataMember(Name = "downloadUrl")]
        public string DownloadUrl { get; set; }

        [DataMember(Name = "releaseType")]
        public string ReleaseType  { get; set; }
        
        #region ICachable Members

        public void SetFromDataReader(SqlDataReader reader)
        {
            this.ID = reader.GetInt32(reader.GetOrdinal("ID"));
            this.ServerModId = reader.GetInt32(reader.GetOrdinal("ProjectID"));
            this.GameVersion = reader.GetString(reader.GetOrdinal("GameVersion"));
            this.FileName = reader.GetString(reader.GetOrdinal("FileName"));
            this.Name = reader.GetString(reader.GetOrdinal("Name"));
            this.DownloadUrl = string.Format(_mediaFileUrl, ID.ToModPath(), FileName);
            var name = Enum.GetName(typeof(EReleaseType), (EReleaseType)reader.GetByte(reader.GetOrdinal("ReleaseType")));
            if (name != null) this.ReleaseType = name.ToLower();
        }

        #endregion
    }
}