﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using MySql.Data.MySqlClient;
using MySql.Data.Types;

namespace ASUserImporter
{
    internal static class Program
    {
        private const int MAX_RANDOM_VALUE = 999999;
        private const string SOURCE_QUERY =
            "SELECT " +
            "username,password,salt," +
            "birthday,email" +
            " FROM user" +
            " ORDER BY username DESC;";
        private const string USERS_QUERY =
            "INSERT INTO users(" +
            "_username,_password,_level,_salt) " +
            "OUTPUT Inserted._uid " +
            "VALUES(" +
            "{0},NULL,100,NULL);";
        private const string EMAILS_QUERY =
            "INSERT INTO useremails(" +
            "_uid,_email,_verified) " +
            "OUTPUT Inserted._id " +
            "VALUES(" +
            "{0},{1},1);";
        private const string PROFILES_QUERY =
            "INSERT INTO userprofiles(" +
            "_uid,_firstName,_lastName," +
            "_birthDate,_gender,_defaultEmail," +
            "_country,_region,_city," +
            "_wantsmail,_registeredVia) VALUES(" +
            "{0},{1},{2}," +
            "{3},{4},{5}," +
            "{6},{7},{8}," +
            "{9},{10});";
        private const string LEGACY_QUERY =
            "INSERT INTO userlegacy(" +
            "_uid,_site,_renamed,_password,_salt) VALUES(" +
            "{0},{1},{2},{3},{4});";

        private static void Main(string[] args)
        {
            string date;
            DateTime dt;
            List<User> users = new List<User>();
            using (MySqlConnection myConn = new MySqlConnection(Properties.Settings.Default.SourceDB))
            {
                myConn.Open();
                MySqlCommand myCmd = new MySqlCommand(SOURCE_QUERY, myConn);

                Console.WriteLine("Loading AS Legacy Users...");
                using (MySqlDataReader myDR = myCmd.ExecuteReader())
                {
                    while (myDR.Read())
                    {
                        User u = new User();
                        u.Username = ((string)myDR["username"]).ToLower();
                        u.Password = (string)myDR["password"];
                        u.Salt = (string)myDR["salt"];
                        u.FirstName = (string)myDR["username"];
                        if (u.FirstName.Length > 32)
                        {
                            u.FirstName = "";
                        }
                        date = (string)myDR["birthday"];
                        if (!DateTime.TryParse(date, out dt))
                        {
                            dt = DateTime.MinValue;
                        }
                        u.BirthDate = dt;
                        u.Gender = 0;
                        u.Country = "UN";
                        u.Email = ((string)myDR["email"]).ToLower();
                        u.Newsletter = false;

                        users.Add(u);
                    }
                }
            }

            List<User> mergedUsers = new List<User>();
            List<User> updatedUsers = new List<User>();
            List<User> badUsers = new List<User>();
            List<User> changedUsers = new List<User>();
            using (SqlConnection msConn = new SqlConnection(Properties.Settings.Default.DestinationDB))
            {
                msConn.Open();
                SqlCommand msCmd = new SqlCommand();
                msCmd.Connection = msConn;
                msCmd.Transaction = msConn.BeginTransaction();
                StringBuilder sql = new StringBuilder();
                Regex userPattern = new Regex("^[a-zA-Z0-9_]+$", RegexOptions.Compiled);
                Random rnd = new Random();
                object uid;
                object emailid;
                string username;
                int count = 0;
                int percent = 0;

                Console.WriteLine("Updating AS Legacy Users");
                foreach (User u in users)
                {
                    int newPercent = (int)(((float)(++count) / users.Count) * 100);
                    if (newPercent != percent)
                    {
                        percent = newPercent;
                        Console.Title = string.Format("Status: {0}%", percent);
                    }

                    // Check if the email already exists in useremails
                    msCmd.CommandText = string.Format("SELECT _uid FROM useremails WHERE _email={0};",
                                                      EscapeAndQuote(u.Email));

                    // If the email is already in useremails, we can consollidate the accounts
                    if ((uid = msCmd.ExecuteScalar()) != null)
                    {
                        msCmd.CommandText = string.Format("SELECT _username FROM users WHERE _uid={0};",
                                                          (int)uid);
                        username = ((string)msCmd.ExecuteScalar()).ToLower();
                        if (u.Username == username)
                        {
                            // If the username is the same, simply inform the user that their password for WOR will be their curse password
                            mergedUsers.Add(u);
                        }
                        else
                        {
                            // If the username is different, inform the user that their username and password for WOR will be their curse username and password
                            u.Username = username;
                            updatedUsers.Add(u);
                        }
                        continue;
                    }


                    // The account could not be consollidated with an existing curse account, so we need to verify the username is valid
                    if (u.Username.Length < 2 ||
                        u.Username.Length > 32 ||
                        !userPattern.IsMatch(u.Username))
                    {
                        // Username is not valid, set the bad username for email reference and generate a username
                        u.BadUsername = u.Username;
                        u.Username = string.Format("user_{0}", rnd.Next(0, MAX_RANDOM_VALUE));
                        badUsers.Add(u);
                    }

                    // Verify that the username we're trying to use doesn't already exist
                    msCmd.CommandText = string.Format("SELECT COUNT(0) FROM users WHERE _username={0};",
                                                      EscapeAndQuote(u.Username));
                    while ((int)msCmd.ExecuteScalar() != 0)
                    {
                        // Username exists
                        // Conflicts with existing user that we cannot verify is the same person, OR
                        // Generated username is already in use
                        if (u.BadUsername.Length == 0)
                        {
                            // If the bad username isn't set, then this is a username conflict
                            // So we add to the changedUsers for an email telling them their new username
                            u.BadUsername = u.Username;
                            changedUsers.Add(u);
                        }
                        u.Username = string.Format("user_{0}", rnd.Next(0, MAX_RANDOM_VALUE));

                        // Keep checking until the username isn't used
                        msCmd.CommandText = string.Format("SELECT COUNT(0) FROM users WHERE _username={0};",
                                                          EscapeAndQuote(u.Username));
                    }

                    // Update the users table
                    sql.Length = 0;
                    sql.AppendFormat(USERS_QUERY,
                                     EscapeAndQuote(u.Username));
                    msCmd.CommandText = sql.ToString();
                    uid = msCmd.ExecuteScalar();

                    // Update the useremails table
                    sql.Length = 0;
                    sql.AppendFormat(EMAILS_QUERY,
                                     (int)uid,
                                     EscapeAndQuote(u.Email));
                    msCmd.CommandText = sql.ToString();
                    emailid = msCmd.ExecuteScalar();

                    // Update the userprofiles table
                    sql.Length = 0;
                    sql.AppendFormat(PROFILES_QUERY,
                                     (int)uid,
                                     EscapeAndQuote(u.FirstName),
                                     u.LastName.Length == 0 ? "NULL" : EscapeAndQuote(u.LastName),
                                     u.BirthDate == DateTime.MinValue ? "NULL" : EscapeAndQuote(u.BirthDate.ToString("yyyy-MM-dd")),
                                     u.Gender,
                                     (int)emailid,
                                     EscapeAndQuote(u.Country),
                                     u.Region.Length == 0 ? "NULL" : EscapeAndQuote(u.Region),
                                     u.City.Length == 0 ? "NULL" : EscapeAndQuote(u.City),
                                     u.Newsletter ? "1" : "0",
                                     Properties.Settings.Default.SiteID);
                    msCmd.CommandText = sql.ToString();
                    msCmd.ExecuteNonQuery();

                    // Update the userlegacy table
                    sql.Length = 0;
                    sql.AppendFormat(LEGACY_QUERY,
                                     (int)uid,
                                     Properties.Settings.Default.SiteID,
                                     u.BadUsername.Length > 0 ? "1" : "0",
                                     EscapeAndQuote(u.Password),
                                     EscapeAndQuote(u.Salt));
                    msCmd.CommandText = sql.ToString();
                    msCmd.ExecuteNonQuery();

                }
                msCmd.Transaction.Commit();
                Console.WriteLine("{0} Total Users", users.Count);
            }

            Console.WriteLine("Emailing users...");
            Console.WriteLine("{0} Merged Users", mergedUsers.Count);
            foreach (User u in mergedUsers)
            {
                // Email user, tell them their WOR login is same username, but password is whatever curse.com has set
            }
            Console.WriteLine("{0} Updated Users", updatedUsers.Count);
            foreach (User u in updatedUsers)
            {
                // Email user, tell them their WOR login has changed to their curse.com login as well as password
            }
            Console.WriteLine("{0} Bad Users", badUsers.Count);
            foreach (User u in badUsers)
            {
                // Email user, tell them their WOR login has been changed and they can login to change it or manually consollidate
            }
            Console.WriteLine("{0} Changed Users", changedUsers.Count);
            foreach (User u in changedUsers)
            {
                // Email user, tell them their WOR login has been changed due to conflict with different email and they can login to change it or manually consollidate
            }

            Console.WriteLine("Done.");
            Console.ReadKey();
        }

        private static String EscapeAndQuote(String pValue)
        {
            return "'" + pValue.Replace("'", "''") + "'";
        }
    }
}
