﻿#define DEBUG_SENDS

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Data;


namespace CurseReportingService
{

    

    class Program
    {
        static void Main(string[] args)
        {

            ReportingEngine.Initialize();
            
            while (true)
            {

                try
                {
                    DoPeriodicTasks();
                    Console.WriteLine("Waiting...");
                }
                catch (Exception ex)
                {
                    Console.WriteLine("Tasks failed with exception: " + ex.Message);
                }

                int sleepMins = 60 - DateTime.Now.Minute;
                Thread.Sleep(1000 * 60 * sleepMins); // 1 hour

            }           

        }

        private static void DoPeriodicTasks()
        {

#if DEBUG
            Console.WriteLine("Sending Daily Report...");
            ReportingEngine.DoDailyReports();
            Console.WriteLine("Sending Hourly Report...");
            ReportingEngine.DoHourlyReports();
            Console.WriteLine("Sending Weekly Report...");
            ReportingEngine.DoWeeklyReports();
            Console.WriteLine("Sending Monthly Report...");
            ReportingEngine.DoMonthlyReports();
            Console.WriteLine("Done");
            return;
#endif
            Console.WriteLine("Sending Hourly Report...");
            ReportingEngine.DoHourlyReports();
            Console.WriteLine("Done");

            if (DateTime.Now.Hour == 9) // Send Daily Report out at 9:00 AM CST
            {
                Console.WriteLine("Sending Daily Report...");
                ReportingEngine.DoDailyReports();
                Console.WriteLine("Done");

                if (DateTime.Now.DayOfWeek == DayOfWeek.Monday) // Send Weekly Report out at 9:00 AM CST on Monday
                {
                    Console.WriteLine("Sending Weekly Report...");
                    ReportingEngine.DoWeeklyReports();
                    Console.WriteLine("Done");
                }

                if (DateTime.Now.Day == 1)
                {
                    Console.WriteLine("Sending Monthly Report...");
                    ReportingEngine.DoMonthlyReports();
                    Console.WriteLine("Done");
                }
            }

            
        }
    }
}
