﻿using System;
using System.Configuration;
using System.Text;
using System.Data.SqlClient;
using System.Collections.Generic;
using CurseReportingService.BillingService;

namespace CurseReportingService
{
    public class SubscriptionsReporter : BaseReportableDatabase
    {

        public SubscriptionsReporter()
        {
            sConnectionString = ConfigurationManager.ConnectionStrings["Subscriptions"].ConnectionString;
        }
        

        public int GetSubscriptionCount(DateTime pFromDate, DateTime pToDate, bool activeOnly, string[] productIDs, bool coupons, ESubscriptionAction action)
        {
            object newSubCount = 0;

            string sql = GetSubscriptionQuery(activeOnly, productIDs, coupons, action);            
          
            using (SqlConnection conn = GetDatabaseConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandTimeout = 1200;
                cmd.CommandText = "select SUM(total) from"
                                + " ("
                                + sql
                                + ") as a";

               
                cmd.Parameters.Add("@fromDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@fromDate"].Value = pFromDate;

                cmd.Parameters.Add("@toDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@toDate"].Value = pToDate;

                newSubCount = cmd.ExecuteScalar();
            }

            if (newSubCount == System.DBNull.Value)
            {
                return 0;
            }
            else
            {
                return (int)newSubCount;
            }
            
        }

        private string GetSubscriptionQuery(bool activeOnly, string[] productIDs, bool coupons, ESubscriptionAction action)
        {
            string sql = String.Empty;

            if (action == ESubscriptionAction.New)
            {
                sql = "select BillingPlanID, count(0) as total from Subscription"
                      + " where ProductID in('" + string.Join("','", productIDs) + "') and DateStarted between @fromDate and @toDate";
            }
            else if (action == ESubscriptionAction.Renewal)
            {
                sql = "SELECT b.BillingPlanID, count(b.BillingPlanID) as total FROM AccountTransaction a, SubscriptionHistory b"
                + " where DateCreated between @fromDate and @toDate and a.userid = 0 and Status = 6 and TYPE = 6 and AccountID like '%U-%'"
                + " and a.AccountID = b.EntitledAccountID and a.PaymentMethodID = b.PaymentMethodID and b.ProductID in('" + string.Join("','", productIDs) + "')";
            }
            else if (action == ESubscriptionAction.Cancellation)
            {
                sql = "select BillingPlanID, count(0) as total from Subscription"
                      + " where ProductID in('" + string.Join("','", productIDs) + "') and DateExpires between @fromDate and @toDate";
            }
            else
            {
                sql = "select BillingPlanID, count(0) as total from Subscription"
                      + " where ProductID in('" + string.Join("','", productIDs) + "') and DateExpires between @fromDate and @toDate";
            }


            if (activeOnly)
            {
                sql += " and DateExpires > GETUTCDATE()";
            }

            if (coupons)
            {
                sql += " and BillingPlanID like '%-C%'";
            }
            else
            {
                sql += " and BillingPlanID not like '%-C%'";
            }

            sql += " group by BillingPlanID";


            return sql;
        }

        public Dictionary<string, int> GetExpiredSubscriptions(DateTime fromDate, DateTime toDate, string[] productIDs)
        {
            Dictionary<string, int> newUserCount = new Dictionary<string, int>();

            // Get the product offering

            using (SqlConnection conn = GetDatabaseConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandTimeout = 1200;
                cmd.CommandText = "select a.BillingPlanID, Count(0) from Subscription as a where a.ProductID in('" + string.Join("','", productIDs) + "')"
                    + " and a.DateExpires between @DateFrom and @DateTo"                    
                    + " and not exists(select top 1 1 from Subscription as b where b.AccountID = a.AccountID and b.ProductID = a.ProductID and b.DateExpires >= @DateTo)" // Ensure they don't have a new sub, coming up
                    + " and exists (select top 1 1 from AccountEntitlement as c where c.AccountID = a.AccountID and c.DateExpires between @DateFrom and @DateTo)" // Ensure they had an entitlement
                    + " group by a.BillingPlanID";

                cmd.Parameters.AddWithValue("@DateFrom", fromDate);
                cmd.Parameters.AddWithValue("@DateTo", toDate);

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        string billingPlanID = reader.GetString(0);
                        string billingPlanDescription = null;

                        using (BillingServiceClient client = new BillingServiceClient("WsHttpClientServiceEndpoint1"))
                        {
                            ServiceResponseOfProductBillingPlan resp = client.GetProductBillingPlan(billingPlanID);
                            billingPlanDescription = resp.Value.Description;
                        }

                        if (!newUserCount.ContainsKey(billingPlanDescription))
                        {
                            newUserCount.Add(billingPlanDescription, 0);
                        }

                        newUserCount[billingPlanDescription] += reader.GetInt32(1);
                    }
                }


            }

            return newUserCount;
        }

        public Dictionary<string, int> GetActiveSubscriptions(DateTime fromDate, DateTime toDate, string[] entitlementIDs, string[] productIDs)
        {
            Dictionary<string, int> newUserCount = new Dictionary<string, int>();

            // Get the product offering

            using (SqlConnection conn = GetDatabaseConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandTimeout = 1200;
                cmd.CommandText = "select BillingPlanID, count(0)"
                    + " from AccountEntitlement"
                    + " inner join Subscription on Subscription.AccountID = AccountEntitlement.AccountID"
                    + " where EntitlementID in ('" + string.Join("','", entitlementIDs) + "') and AccountEntitlement.DateExpires > GETUTCDATE()"
                    + " and Subscription.DateExpires > GETUTCDATE() and Subscription.DateStarted <= GETUTCDATE()"
                    + " and Subscription.ProductID in ('" + string.Join("','", entitlementIDs) + "')"
                    + " group by BillingPlanID";

                cmd.Parameters.AddWithValue("@DateFrom", fromDate);
                cmd.Parameters.AddWithValue("@DateTo", toDate);

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        string billingPlanID = reader.GetString(0);
                        string billingPlanDescription = null;

                        using (BillingServiceClient client = new BillingServiceClient("WsHttpClientServiceEndpoint1"))
                        {
                            ServiceResponseOfProductBillingPlan resp = client.GetProductBillingPlan(billingPlanID);
                            billingPlanDescription = resp.Value.Description;
                        }

                        if (!newUserCount.ContainsKey(billingPlanDescription))
                        {
                            newUserCount.Add(billingPlanDescription, 0);
                        }

                        newUserCount[billingPlanDescription] += reader.GetInt32(1);
                    }
                }


            }

            return newUserCount;
        }

        public Dictionary<string, int> GetTransactionCountByProduct(DateTime fromDate, DateTime toDate, string[] productIDs)
        {
            Dictionary<string, int> newUserCount = new Dictionary<string, int>();
            using (SqlConnection conn = GetDatabaseConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandTimeout = 1200;
                cmd.CommandText = "select b.Description, count(0) from AccountTransaction as a"
                                  + " inner join AccountTransactionItem as b on b.TransactionID = a.ID"
                                  + " where a.Type = 1" // New
                                  + " and a.Status in (3,4,6,7)"
                                  + " and a.DateCreated between @DateFrom and @DateTo"
                                  + " and b.ProductID in('" + string.Join("','", productIDs) + "')"
                                  + " group by b.Description";

                cmd.Parameters.AddWithValue("@DateFrom", fromDate);
                cmd.Parameters.AddWithValue("@DateTo", toDate);

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        string billingPlanDescription = reader.GetString(0);
                        newUserCount[billingPlanDescription] = reader.GetInt32(1);
                    }
                }
            }

            return newUserCount;
        }


        public Dictionary<string, int> GetSubscriptionCountWithType(DateTime fromDate, DateTime toDate, bool activeOnly, string[] productIDs, bool coupons, ESubscriptionAction action)
        {
            Dictionary<string, int> newUserCount = new Dictionary<string, int>();

            // Get the product offering
                        
            using (SqlConnection conn = GetDatabaseConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandTimeout = 1200;
                cmd.CommandText = GetSubscriptionQuery(activeOnly, productIDs, coupons, action) + " order by total desc";

                cmd.Parameters.Add("@fromDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@fromDate"].Value = fromDate;

                cmd.Parameters.Add("@toDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@toDate"].Value = toDate;

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        string billingPlanID = reader.GetString(0);
                        string billingPlanDescription = null;
                        
                        using (BillingServiceClient client = new BillingServiceClient("WsHttpClientServiceEndpoint1"))
                        {
                            ServiceResponseOfProductBillingPlan resp = client.GetProductBillingPlan(billingPlanID);
                            billingPlanDescription = resp.Value.Description;
                        }

                        if(!newUserCount.ContainsKey(billingPlanDescription))
                        {
                            newUserCount.Add(billingPlanDescription, 0);
                        }

                        newUserCount[billingPlanDescription] += reader.GetInt32(1);
                    }
                }


            }

            return newUserCount;
        }

        public Dictionary<string, int> GetCouponUsageByReasonAndDateRange(DateTime fromDate, DateTime toDate)
        {
            Dictionary<string, int> newUserCount = new Dictionary<string, int>();


            using (SqlConnection conn = GetDatabaseConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = @"SELECT CASE WHEN b.CouponPurpose IS NULL THEN 'Unknown' ELSE b.CouponPurpose END as CouponPurpose, count(distinct(a.SubscriptionID)) as total
                    FROM SubscriptionHistory a, Coupon b, CouponUsage c
                    where BillingPlanID like '%-C%' and a.EntitledAccountID = c.ClaimedAccountID and c.CouponID = b.ID and (a.TimeStamp between @fromDate and @toDate) and b.ExpirationDate > @fromDate
                    group by b.CouponPurpose
                    order by total desc";

                cmd.Parameters.Add("@fromDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@fromDate"].Value = fromDate;

                cmd.Parameters.Add("@toDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@toDate"].Value = toDate;

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        string purpose = reader[0].ToString();
                        int total = Convert.ToInt32(reader[1]);

                        newUserCount.Add(purpose, total);
                    }
                }
            }
            return newUserCount;

        }

    }
}
