﻿using System;
using System.Configuration;
using System.Text;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.Data;

namespace CurseReportingService
{
    public class V4ClientReporter : BaseReportableDatabase
    {

        public V4ClientReporter()
        {
            sConnectionString = ConfigurationManager.ConnectionStrings["ClientV4"].ConnectionString;
        }
        
        public int GetNewUserCount(DateTime pFromDate, DateTime pToDate, EPlatform platform)
        {
            object newUserCount = 0;

            using (SqlConnection conn = GetDatabaseConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select count(0) from ClientUser where DateFirstSeen between @fromDate and @toDate";
                cmd.CommandText += " and OperatingSystemPlatformID = " + (int)platform;
                
                cmd.Parameters.Add("@fromDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@fromDate"].Value = pFromDate;
                
                cmd.Parameters.Add("@toDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@toDate"].Value = pToDate;

                newUserCount = cmd.ExecuteScalar();
            }

            return (int)newUserCount;
        }

        public int GetActiveUserCount(DateTime pFromDate, DateTime pToDate, EPlatform platform)
        {
            object activeUserCount = 0;

            using (SqlConnection conn = GetDatabaseConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select count(0) from ClientUser where DateLastSeen between @fromDate and @toDate";
                cmd.CommandText += " and OperatingSystemPlatformID = " + (int)platform;

                cmd.Parameters.Add("@fromDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@fromDate"].Value = pFromDate;

                cmd.Parameters.Add("@toDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@toDate"].Value = pToDate;

                activeUserCount = cmd.ExecuteScalar();
            }

            return (int)activeUserCount;
        }

        public int GetRecentUserCount(DateTime pFromDate, EPlatform platform)
        {
            object recentUserCount = 0;

            using (SqlConnection conn = GetDatabaseConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select count(0) from ClientUser where DateLastSeen >= @fromDate";
                cmd.CommandText += " and OperatingSystemPlatformID = " + (int)platform;
                cmd.Parameters.Add("@fromDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@fromDate"].Value = pFromDate;

                recentUserCount = cmd.ExecuteScalar();
            }

            return (int)recentUserCount;
        }

        public int GetTotalUserCount(bool pActiveOnly, EPlatform platform)
        {

            int totalUserCount = 0;

            using (SqlConnection conn = GetDatabaseConnection())
            {
                SqlCommand cmd = conn.CreateCommand();

                cmd.CommandText = "select count(distinct(UserID)) from dbo.ClientUser";
                cmd.CommandText += " where OperatingSystemPlatformID = " + (int)platform;                
                if(pActiveOnly)
                {
                    cmd.CommandText += " and DateLastSeen >= DATEADD(MONTH, -3, GETUTCDATE());";
                }

                totalUserCount = (int)cmd.ExecuteScalar();
            }

            return totalUserCount;
           
        }

        public Dictionary<string, int> GetUsageByClientVersion(bool pActiveOnly, DateTime pFromDate, DateTime pToDate, EPlatform platform, int smallSampleThreshold)
        {
            Dictionary<string, int> newUserCount = new Dictionary<string, int>();

            using (SqlConnection conn = GetDatabaseConnection())
            {
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select top 10 LookupLabel, count(0) as total from ClientUser inner join ClientVersion on ClientVersion.LookupID = ClientUser.ClientVersionID";
                cmd.CommandText += " where OperatingSystemPlatformID = " + (int)platform;

                if (pActiveOnly)
                {
                    cmd.CommandText += " and DateLastSeen >= @fromDate";
                }
                cmd.CommandText += " group by LookupLabel order by total desc";

                cmd.Parameters.Add("@fromDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@fromDate"].Value = pFromDate;

                cmd.Parameters.Add("@toDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@toDate"].Value = pToDate;

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    int total = 0;
                    while (reader.Read())
                    {
                        total = reader.GetInt32(1);
                        if (total >= smallSampleThreshold)
                        {
                            newUserCount.Add(reader.GetString(0), total);
                        }
                    }
                }
            }

            return newUserCount;
        }

        public Dictionary<string, int> GetUsageByOSVersion(bool pActiveOnly, DateTime pFromDate, DateTime pToDate, EPlatform platform, int smallSampleThreshold)
        {
            Dictionary<string, int> newUserCount = new Dictionary<string, int>();

            using (SqlConnection conn = GetDatabaseConnection())
            {


                SqlCommand fixCmd = conn.CreateCommand();
                fixCmd.CommandType = System.Data.CommandType.StoredProcedure;
                fixCmd.CommandText = "spFixOsVersion";
                fixCmd.ExecuteNonQuery();

                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select top 10 LookupLabel, count(0) as total from ClientUser inner join OperatingSystemVersion on OperatingSystemVersion.LookupID = ClientUser.OperatingSystemVersionID";

                cmd.CommandText += " where OperatingSystemPlatformID = " + (int)platform;

                if (pActiveOnly)
                {
                    cmd.CommandText += " and DateLastSeen >= @fromDate";
                }
                cmd.CommandText += " group by LookupLabel order by total desc";

                cmd.Parameters.Add("@fromDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@fromDate"].Value = pFromDate;

                cmd.Parameters.Add("@toDate", System.Data.SqlDbType.DateTime);
                cmd.Parameters["@toDate"].Value = pToDate;

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    int total = 0;
                    while (reader.Read())
                    {
                        total = reader.GetInt32(1);
                        if (total >= smallSampleThreshold)
                        {
                            newUserCount.Add(reader.GetString(0), total);
                        }
                    }
                }
            }

            return newUserCount;
        }

        public List<CloudUsageRecord> GetCloudUsage(bool activeOnly, DateTime pFromDate, DateTime pToDate)
        {
            List<CloudUsageRecord> results = new List<CloudUsageRecord>();

            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["ClientService"].ConnectionString))
            {
                conn.Open();

                SqlCommand cmd = conn.CreateCommand();

                string strSQL = String.Empty;

                if (activeOnly)
                {
                    strSQL = "select a.GameID, (sum(b.filesize) / (1024*1024)) as space_used, COUNT(distinct(a.UserID)) as users ";
                    strSQL += "FROM SavedGame a, SavedGameRevision b WHERE a.id = b.savedGameId and a.DateCreated between @dateFrom and @dateTo ";
                    strSQL += "group by a.gameid";

                    cmd.Parameters.AddWithValue("dateFrom", pFromDate);
                    cmd.Parameters.AddWithValue("dateTo", pToDate);
                }
                else
                {
                    strSQL = @"select a.GameID, (sum(b.filesize) / (1024*1024)) as space_used, COUNT(distinct(a.UserID)) as users
                    FROM SavedGame a, SavedGameRevision b
                    where a.id = b.savedgameid
                    group by a.gameid";
                }

                cmd.CommandText = strSQL;


                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        CloudUsageRecord r = new CloudUsageRecord();

                        r.GameId = (EGame)reader.GetInt32(0);
                        r.SpaceUsed = reader.GetInt64(1);
                        r.UserCount = reader.GetInt32(2);

                        results.Add(r);
                    }
                }

                conn.Close();

            }

            return results;


        }

        public List<SavedGameRecord> GetSavedGameCounts()
        {

            List<SavedGameRecord> results = new List<SavedGameRecord>();

            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["ClientV4"].ConnectionString))
            {
                conn.Open();

                SqlCommand cmd = conn.CreateCommand();


                cmd.CommandText = @"SELECT distinct(gameid), count(userid), sum(Localsavescount)
                                    FROM GameMetrics
                                    where LocalSavesCount > 0
                                    group by GameID
                                    order by GameID";
                
                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        SavedGameRecord r = new SavedGameRecord();

                        r.GameId = (EGame)reader.GetInt32(0);
                        r.UserCount = reader.GetInt32(1);
                        r.Saves = reader.GetInt32(2);

                        results.Add(r);
                    }
                }

                conn.Close();

            }

            return results;
        }

        public List<GameStatsRecord> GetGameStatsInfo(bool activeOnly, DateTime pFromDate, DateTime pToDate)
        {

            List<GameStatsRecord> results = new List<GameStatsRecord>();

            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["ClientV4"].ConnectionString))
            {
                conn.Open();

                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = @"select distinct(a.game), (a.installs + b.installs) as totalInstalls, (a.defaults + b.defaults) as totalDefaults
                                    from (
                                    SELECT distinct(gameid) as game, count(gameid) as installs, 0 as defaults
                                      FROM GameMetrics
                                      group by GameID )a
                                    inner join (
                                    SELECT distinct(b.defaultgameid) as game, 0 as installs, count(b.defaultgameid) as defaults
                                      FROM ClientUser b
                                      where b.DefaultGameID is not null
                                      group by DefaultGameID
                                      ) b on a.game = b.game
                                      order by totalInstalls desc";

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        GameStatsRecord r = new GameStatsRecord();

                        r.GameId = (EGame)reader.GetInt32(0);
                        r.Installs = reader.GetInt32(1);
                        r.Defaults = reader.GetInt32(2);

                        results.Add(r);
                    }
                }

                conn.Close();

            }

            return results;
        }

        public List<GameFeatureUsageRecord> GetGameFeatureUsageInfo(bool activeOnly, DateTime pFromDate, DateTime pToDate)
        {

            List<GameFeatureUsageRecord> results = new List<GameFeatureUsageRecord>();

            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["ClientV4"].ConnectionString))
            {
                conn.Open();

                SqlCommand cmd = conn.CreateCommand();

                string strSQL = String.Empty;

                if (activeOnly)
                {
                    strSQL = "select a.Gameid, a.tabdescription, SUM(b.timesselected) as uses from GameTab a, GameMetricsGameTabMapping b ";
                    strSQL += "where b.GameTabID = a.ID and b.DateModified between @dateFrom and @dateTo and b.dateCreated between @dateFrom and @dateTo ";
                    strSQL += "group by a.TabDescription, a.ID, a.GameID ";
                    strSQL += "order by uses desc";

                    cmd.Parameters.AddWithValue("dateFrom", pFromDate);
                    cmd.Parameters.AddWithValue("dateTo", pToDate);
                
                }
                else
                {
                    strSQL = @"select a.Gameid, a.tabdescription, SUM(b.timesselected) as uses
                                    from GameTab a, GameMetricsGameTabMapping b
                                    where b.GameTabID = a.ID
                                    group by a.TabDescription, a.ID, a.GameID
                                    order by uses desc";
                }

                cmd.CommandText = strSQL;

                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        GameFeatureUsageRecord r = new GameFeatureUsageRecord();

                        r.GameId = (EGame)reader.GetInt32(0);
                        r.Description = reader.GetString(1);
                        r.Uses = reader.GetInt32(2);

                        results.Add(r);
                    }
                }

                conn.Close();

            }

            return results;
        }
    }
}
