﻿using System;
using System.Collections.Generic;
using System.Text;

namespace WoWDataCompare
{
    internal static class Program
    {
        private static Boolean sProcessCreature = false;
        private static Boolean sProcessGameObject = false;
        private static Boolean sProcessItem = false;
        private static Boolean sProcessPageText = false;
        private static Boolean sProcessQuest = false;

        private static void Main(String[] pArgs)
        {
            if (!ParseArgs(pArgs))
            {
                return;
            }

            if (sProcessCreature)
            {
                DB.ProcessCreature();
            }
            if (sProcessGameObject)
            {
                DB.ProcessGameObject();
            }
            if (sProcessItem)
            {
                DB.ProcessItem();
            }
            if (sProcessPageText)
            {
                DB.ProcessPageText();
            }
            if (sProcessQuest)
            {
                DB.ProcessQuest();
            }

            Console.Write("Press any key to exit");
            Console.ReadKey(true);
        }

        private static Boolean ParseArgs(String[] pArgs)
        {
            for (Int32 index = 0; index < pArgs.Length; ++index)
            {
                switch (pArgs[index].ToLower())
                {
                    case "-creature":
                    case "-c":
                        sProcessCreature = true;
                        break;
                    case "-gameobject":
                    case "-go":
                        sProcessGameObject = true;
                        break;
                    case "-item":
                    case "-i":
                        sProcessItem = true;
                        break;
                    case "-pagetext":
                    case "-pt":
                        sProcessPageText = true;
                        break;
                    case "-quest":
                    case "-q":
                        sProcessQuest = true;
                        break;
                    case "-?":
                        Console.WriteLine("Syntax: WoWDataCompare [options]");
                        Console.WriteLine("Options:");
                        Console.WriteLine("  -creature, -c");
                        Console.WriteLine("  -gameobject, -go");
                        Console.WriteLine("  -item, -i");
                        Console.WriteLine("  -pagetext, -pt");
                        Console.WriteLine("  -quest, -q");
                        return false;
                    default:
                        Console.WriteLine("Unknown argument, try -?");
                        return false;
                }
            }
            return true;
        }
    }
}
