﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Curse.ClientService.Models;
using System.ServiceModel;
using System.IO;
using System.Configuration;
using System.Net;

namespace Curse.CurseClient.Common
{
    public class CLoginResult
    {
        private bool _isSuccessful = false;
        private EAuthenticationStatus _status;
        private string _message = null;
        private Exception _exception = null;

        public CLoginResult() { }

        public CLoginResult(Exception ex)
        {
            _exception = ex;
        }

        public CLoginResult(Exception ex, bool isSuccessful, EAuthenticationStatus status)
        {
            _exception = ex;
            _isSuccessful = isSuccessful;
            _status = status;
        }

        public CLoginResult(Exception ex, bool isSuccessful, EAuthenticationStatus status, string message)
        {
            _exception = ex;
            _isSuccessful = isSuccessful;
            _status = status;
            _message = message;
        }

        public Exception Exception
        {
            get
            {
                return _exception;
            }
            set
            {
                _exception = value;
            }
        }

        public bool IsSuccessful
        {
            get
            {
                return _isSuccessful;
            }
            set
            {
                _isSuccessful = value;
            }
        }

        public EAuthenticationStatus Status
        {
            get
            {
                return _status;
            }
            set
            {
                _status = value;
            }
        }

        public string Message
        {
            get
            {
                if (Exception != null && string.IsNullOrEmpty(_message))
                {
                    return "Curse Client v4 was unable to connect to the Curse login server.\r\n\r\nThe message reported is: " + Exception.Message;
                }
                else
                {
                    return _message;
                }
            }
        }

        public static CLoginResult GetFromException(Exception ex)
        {
            FaultException faultEx = ex.GetBaseException() as FaultException;
            int reasonCode = -1;

            if (ex.ContainsType(typeof(TypeLoadException)) && ex.Message.Contains("ExtendedProtectionPolicy"))
            {
                string uninstallMessage = "To do this, go to the Windows Control Panel, click the 'Uninstall a program' link in the 'Programs' section, and then click the 'View installed updates' link in the sidebar.";

                if (Environment.OSVersion.Version.Major == 5) // Windows XP
                {
                    uninstallMessage = "To do this, go to the Windows Control Panel, double click the 'Add/Remove Programs' icon, and check the 'Show Updates' option.";
                }

                return new CLoginResult(ex, false, EAuthenticationStatus.UnknownError, "A recent Windows Update has corrupted the Windows Communication Foundation components installed on your computer. Microsoft is advising users to uninstall the following Windows Updates to correct the problem: 'KB982168' and 'KB976769v2'.\r\n\r\n" + uninstallMessage + " Scroll down to the 'Microsoft .NET Framework 3.0 Service Pack 2' section, and uninstall 'KB982168' and 'KB976769v2'.\r\n\r\nUntil Microsoft has released a new Windows Update to correct this problem, be sure to disable automatic Windows Updates (from the Control Panel).");
            }
            else if (ex.ContainsType(typeof(FileNotFoundException)) || ex.ContainsType(typeof(ConfigurationErrorsException))) // File not found or config errors
            {
                return new CLoginResult(ex, false, EAuthenticationStatus.CorruptLibrary);
            }
            else if (ex.ContainsType(typeof(ProtocolException)) || ex.ContainsType(typeof(NotSupportedException)) || ex.ContainsType(typeof(WebException)) || ex.ContainsType(typeof(EndpointNotFoundException)))
            {
                return new CLoginResult(ex, false, EAuthenticationStatus.UnknownError, "Curse Client v4 was unable to connect to the Curse login server, due to a blocked or unavailable Internet connection. Please verify that you are not behind a firewall or proxy server which may be blocking this connection.\r\n\r\nThe message reported is: " + ex.Message);
            }
            else if (faultEx != null && int.TryParse(faultEx.Message, out reasonCode))
            {
                return new CLoginResult(faultEx, false, (EAuthenticationStatus)reasonCode);
            }
            else
            {
                return new CLoginResult(ex, false, EAuthenticationStatus.UnknownError);
            }

        }

    }
}
