﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;
using System.Net;
using System.IO;
using System.Security.Cryptography;
using System.Configuration;
using Curse.Extensions;
using Curse.CurseClient.Common.ClientService;
//using Curse.CurseClient.Enumerations;
using Curse.ClientService.Models;

namespace Curse.CurseClient.Common
{
    public static class CClientLogin
    {
        private static readonly string _curseforgeKey = "4baJYazVP9vRdDkra8t2xZk6rBwjX2VIoWOb+mbMhlKcgQxbqaMF63Rw4cXBHlqcI06i12uU03lN/ONaUvSa";
        private static readonly string _localEncryptionSeed = "31ED549B43318C9CFAE926ADE1720D2202C2DEFFAB06AE9D78FB6F16DF2D70A4";
        private static readonly string _outgoingEncryptionSeed = "31ED549B43318C9CFAE926ADE1720D2202C2DEFFAB06AE9D78FB6F16DF2D70A4";
        private static readonly StringCipher _localCipher;
        private static readonly StringCipher _outgoingCipher;

        static CClientLogin()
        {
            _localCipher = new StringCipher(_localEncryptionSeed);
            _outgoingCipher = new StringCipher(_outgoingEncryptionSeed);
        }

        public static string EncryptLocalString(string value)
        {
            return _localCipher.Encrypt(value);
        }

        public static string EncryptOutgoingString(string value)
        {
            return _outgoingCipher.Encrypt(value);
        }

        public static string DecryptLocalString(string value)
        {
            string unencrypted = value;
            try
            {
                unencrypted = _localCipher.Decrypt(value);
            }
            catch { }
            return unencrypted;
        }

        public static string GetCurseforgeKey()
        {
            string plainText = _curseforgeKey + "-" + CServiceProxy.Instance.UserID;
            byte[] plainBytes = Encoding.ASCII.GetBytes(plainText);
            SHA1Managed hashAlgorithm = new SHA1Managed();
            byte[] hashBytes = hashAlgorithm.ComputeHash(plainBytes);
            return hashBytes.ToHexString().ToLowerInvariant();
        }

    }

}
