﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Curse.CurseClient.Common
{
    public static class CClientServiceConstants
    {
        public static string ServiceHost
        {
            get
            {
#if DEBUG
                return "http://testclientservice.curse.com/";
                //return "http://devclientservice.curse.local/";
#elif TEST
                return "http://testclientservice.curse.com/";
#else
                return "http://clientservice.curse.com/";
#endif

            }
        }
        public static string UploadHost
        {
            get
            {
#if DEBUG
                return "http://testclientservice-upload.curse.com/";
                //return "http://devclientservice-upload.curse.local/";
#elif TEST
                return "http://testclientservice-upload.curse.com/";
#else
                return "http://clientservice-upload.curse.com/";
#endif

            }
        }
        public static string StaticHost
        {
            get
            {
#if DEBUG
                return "http://testclientupdate.curse.com/";
                //return "http://devclientupdate.curse.local/";
#elif TEST
                return "http://testclientupdate.curse.com/";
#else
                return "http://clientupdate.curse.com/";
#endif

            }
        }

        public static string TicketServiceUrl
        {
            get
            {
#if DEBUG
                return "http://clientsupport.curse.com/api/TicketService.asmx";
#else
                return "http://clientsupport.curse.com/api/TicketService.asmx";
#endif
            }
        }

        public static string GetServiceUrl(string url)
        {
            return ServiceHost + url;
        }

        public static string GetStaticUrl(string url)
        {
            return StaticHost + url;
        }

    }
}
