﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Media;
using System.Windows;
using System.Windows.Threading;
using Curse.CurseClient.Common.Properties;
using System.Reflection;
using System.Configuration;
using System.Diagnostics;

namespace Curse.CurseClient.Common
{
    public static class CSystemInformationUtility
    {
        public static string GetDisplayResolution()
        {
            try
            {
                return SystemParameters.PrimaryScreenWidth + " x " + SystemParameters.PrimaryScreenHeight;
            }
            catch
            {
                return "Unknown";
            }
        }

        public static string GetUserSettings()
        {
            try
            {
                List<string> ignoredSettings = new List<string> { "IncompatibilityAlertHistory", "PublicKeyToken", "Username", "Password", "EncryptedPassword" };
                SettingsPropertyValueCollection properties = Settings.Default.PropertyValues;
                List<string> userSettings = new List<string>();
                foreach (SettingsPropertyValue property in properties)
                {
                    if (ignoredSettings.Contains(property.Name))
                    {
                        continue;
                    }

                    userSettings.Add(property.Name + ": " + property.PropertyValue.ToString());
                    userSettings.Sort();
                }

                return string.Join(Environment.NewLine, userSettings.ToArray());

            }
            catch
            {
                return "Unknown";
            }
        }

        public static string GetSystemDpi()
        {

            string systemDpi = null;

            CUtility.MainDispatcher.Invoke(DispatcherPriority.Normal, (Action)(() =>
            {
                try
                {
                    Matrix m = PresentationSource.FromVisual(Application.Current.MainWindow).CompositionTarget.TransformToDevice;
                    double dx = m.M11 * 96.0;
                    double dy = m.M22 * 96.0;
                    systemDpi = dx + " dpi, " + dy + " dpi";
                }
                catch { }
            }));

            return systemDpi == null ? "Unknown" : systemDpi;

        }

        public static string GetOperatingSystemName()
        {
            string name = null;

            OperatingSystem version = System.Environment.OSVersion;

            switch (version.Platform)
            {
                case PlatformID.Unix:
                    break;
                case PlatformID.Win32NT:
                    switch (version.Version.Major)
                    {
                        case 3:
                            name = "Windows NT 3.51";
                            break;
                        case 4:
                            name = "Windows NT 4.0";
                            break;
                        case 5:
                            switch (version.Version.Minor)
                            {
                                case 0:
                                    name = "Windows 2000";
                                    break;
                                case 1:
                                    name = "Windows XP";
                                    break;
                                case 2:
                                    name = "Windows 2003";
                                    break;
                                default:
                                    break;
                            }
                            break;
                        case 6:
                            switch (version.Version.Minor)
                            {
                                case 0:
                                    name = "Windows Vista";
                                    break;
                                case 1:
                                    name = "Windows 7";
                                    break;
                                default:
                                    break;
                            }
                            break;

                        default:
                            name = "Unknown Win32NT Windows";
                            break;
                    }
                    break;
                case PlatformID.Win32S:
                    break;
                case PlatformID.Win32Windows:
                    switch (version.Version.Major)
                    {
                        case 0:
                            name = "Windows 95";
                            break;
                        case 10:
                            if (version.Version.Revision.ToString() == "2222A")
                                name = "Windows 98 Second Edition";
                            else
                                name = "Windows 98";
                            break;
                        case 90:
                            name = "Windows ME";
                            break;
                        default:
                            name = "Unknown Win32 Windows";
                            break;
                    }
                    break;
                case PlatformID.WinCE:
                    break;
                default:
                    break;
            }

            if (name == null)
            {
                name = "Unknown";
            }

            return name;
        }

        public static string GetProgramFilesFolder()
        {
            String x86folder = Environment.GetEnvironmentVariable("ProgramFiles(x86)");
            if (x86folder != null)
            {
                return x86folder;
            }
            else
            {
                return Environment.GetEnvironmentVariable("ProgramFiles");
            }
        }

    }
}
