﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Deployment.Application;
using System.Windows.Forms;
using System.IO;
using System.Threading;
using Microsoft.Win32;

using Curse.Extensions;
using System.Windows.Threading;

namespace Curse.CurseClient.Common
{
    public static class CUtility
    {
        private static string _tempPath = null;
        private static string _personalPath = null;
        private static int _uniqueNumber = 0;
        private static Dispatcher _mainDispatcher;
        private static string _userAgent;

        public static string NextGuid
        {
            get
            {
                return System.Guid.NewGuid().ToString();
            }

        }
        public static string GetMyCurseFolder(string folderName)
        {
            string rootBackupFolder = Environment.GetFolderPath(Environment.SpecialFolder.Personal) + "\\My Curse\\Curse Client\\";
            if (Directory.Exists(rootBackupFolder) == false) { Directory.CreateDirectory(rootBackupFolder); }

            if (Directory.Exists(rootBackupFolder + folderName) == false) { Directory.CreateDirectory(rootBackupFolder + folderName); }
            return rootBackupFolder + folderName;
        }
        public static bool Cleanup()
        {
            CleanupTempFiles();
            return true;
        }

        public static void CleanupTempFiles()
        {
            DirectoryInfo dir = new DirectoryInfo(CUtility.TempPath);
            if (dir.Exists)
            {
                try
                {
                    dir.Delete(true);
                    _tempPath = null;
                }
                catch (Exception)
                {
                }

            }
        }

        public static string GetDataPathFilename(string filename)
        {
            return Path.Combine(DataPath, filename);
        }

        public static string DataPath
        {
            get
            {
                if (CDeploymentUtility.IsNetworkDeployed)
                {
                    return ApplicationDeployment.CurrentDeployment.DataDirectory;
                }
                else
                {
                    return Application.UserAppDataPath;
                }
            }
        }


        public static string GetNextTempfile(string fileExtension)
        {
            return Path.Combine(CUtility.TempPath, CUtility.UniqueNumber.ToString()) + fileExtension;
        }

        public static string TempPath
        {
            get
            {
                if (_tempPath != null)
                {
                    if (!System.IO.Directory.Exists(_tempPath))
                    {
                        System.IO.Directory.CreateDirectory(_tempPath);
                    }
                }
                else
                {
                    string tempPath = Path.Combine(Path.GetTempPath(), "Curse\\" + CUtility.UniqueNumber.ToString());
                    if (!System.IO.Directory.Exists(tempPath))
                    {
                        System.IO.Directory.CreateDirectory(tempPath);
                    }
                    _tempPath = tempPath;
                }
                return _tempPath;
            }
        }


        public static string PersonalPath
        {
            get
            {
                if (_personalPath != null)
                {
                    if (!System.IO.Directory.Exists(_personalPath))
                    {
                        System.IO.Directory.CreateDirectory(_personalPath);
                    }
                }
                else
                {
                    string personalPath = Environment.GetFolderPath(Environment.SpecialFolder.Personal) + "\\Curse Client";
                    if (!System.IO.Directory.Exists(personalPath))
                    {
                        System.IO.Directory.CreateDirectory(personalPath);
                    }
                    _personalPath = personalPath;
                }
                return _personalPath;
            }
        }

        public static bool AddFirewallException()
        {
            try
            {
                string firewallAppName = "Curse Client 4.0";
                if (FirewallHelper.Instance.IsFirewallEnabled && FirewallHelper.Instance.AppAuthorizationsAllowed)
                {
                    FirewallHelper.Instance.RemoveAuthorizationByName(firewallAppName);
                    FirewallHelper.Instance.GrantAuthorization(Application.ExecutablePath, "Curse Client 4.0");
                }
                return true;
            }
            catch (Exception ex)
            {
                Logger.Log("AddFirewallException Failed! Message: {0}. Stack: {1}.", ELogLevel.Error, ex.Message, ex.StackTrace);
                return false;
            }
        }

        public static int UniqueNumber
        {
            get
            {
                return Interlocked.Increment(ref _uniqueNumber);
            }
        }

        public static string GetNormalizedPath(string path)
        {
            DirectoryInfo info = new DirectoryInfo(path);
            if (!info.Exists)
            {
                return path;
            }
            path = info.FullName;
            if (!path.EndsWith(Path.DirectorySeparatorChar.ToString()))
            {
                path = path + Path.DirectorySeparatorChar.ToString();
            }
            return path;
        }

        public static Version ApplicationVersion
        {
            get
            {
                if (CDeploymentUtility.IsNetworkDeployed)
                {
                    ApplicationDeployment ad = ApplicationDeployment.CurrentDeployment;
                    return ad.CurrentVersion;
                }
                else
                {
                    return new Version(System.Windows.Forms.Application.ProductVersion);
                }
            }
        }

        public static string GetClientAndOSVersion()
        {
            return string.Format("Curse Client {0}, {1}", ApplicationVersion, Environment.OSVersion.VersionString);
        }

        public static Dispatcher MainDispatcher
        {
            get
            {
                if (_mainDispatcher == null)
                {
                    return Dispatcher.CurrentDispatcher;
                }
                else
                {
                    return _mainDispatcher;
                }
            }
            set
            {
                _mainDispatcher = value;
            }
        }

        public static string UserAgent
        {

            get
            {
                if (_userAgent == null)
                {
                    Version version = ApplicationVersion;
                    _userAgent = "CurseClient/{0}.{1} ({2}) CurseClient/{3}.{4}.{5}.{6}".FormatWith(
                        version.Major,
                        version.Minor,
                        Environment.OSVersion.VersionString,
                        version.Major,
                        version.Minor,
                        version.Build,
                        version.Revision
                        );
                }
                return _userAgent;
            }

        }


    }
}
