﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace ServiceUnitTests.Common
{
    public class MessageBuilder
    {
        List<byte> buffer;
        public MessageBuilder()
        {
            buffer = new List<byte>();
        }

        public void Append(byte value)
        {
            buffer.Add(value);
        }
        public void Append(int value)
        {
            for (int i = 0; i <= 3; i++)
            {
                buffer.Add((byte)((value >> (i * 8)) & 0x000000FF));
            }
        }
        public void Append(string value)
        {
            Append(value.Length);
            for (int i = 0; i < value.Length; i++)
            {
                buffer.Add((byte)value[i]);
            }
        }
        public void Append(byte[] value)
        {
            buffer.AddRange(value);
        }
        //public void Append(bool value)
        //{
        //    // Try the simple method
        //    buffer.Add(value ? (byte)1 : (byte)0);

        //    //The hard way
        //    //int bytes = bools.Length / 8;
        //    //if ((bools.Length % 8) != 0) bytes++;
        //    //byte[] arr2 = new byte[bytes];
        //    //int bitIndex = 0, byteIndex = 0;
        //    //for (int i = 0; i < bools.Length; i++)
        //    //{
        //    //    if (bools[i])
        //    //    {
        //    //        arr2[byteIndex] |= (byte)(((byte)1) << bitIndex);
        //    //    }
        //    //    bitIndex++;
        //    //    if (bitIndex == 8)
        //    //    {
        //    //        bitIndex = 0;
        //    //        byteIndex++;
        //    //    }
        //    //}
        //}

        public byte[] ToArray()
        {
            return buffer.ToArray();
        }
    }
}
