﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ServiceUnitTests.BillingService;
using Curse.Billing.Models;

namespace ServiceUnitTests.Common {
    public static class Products {
        //static string[] _productIds = new string[] { "CP", "GH", "CP-G", "VH", "GHV", "GHT-1", "VHT-2", "GHT-15", "GHT-30", "GHT-90", "GHT-180", "GHT-360", "GH-G" };
        static string[] _tokenProductIds = new string[] { "GHT-1", "VHT-2", "GHT-15", "GHT-30", "GHT-90", "GHT-180", "GHT-360" };
        static Dictionary<string, List<string>> _billingPlanIds;

        public static string CursePremium { get { return "CP"; } }
        public static string GuildHosting { get { return "GH"; } }
        public static string CursePremium_Gift { get { return "CP-G"; } }
        public static string VentriloHosting { get { return "VH"; } }
        public static string GuildHostingWithVentrillo { get { return "GHV"; } }
        public static string GuildHosting_1Token { get { return "GHT-1"; } }
        public static string VentriloHosting_2Tokens { get { return "VHT-2"; } }
        public static string GuildHosting_15Tokens { get { return "GHT-15"; } }
        public static string GuildHosting_30Tokens { get { return "GHT-30"; } }
        public static string GuildHosting_90Tokens { get { return "GHT-90"; } }
        public static string GuildHosting_180Tokens { get { return "GHT-180"; } }
        public static string GuildHosting_360Tokens { get { return "GHT-360"; } }
        public static string GuildHosting_Gift { get { return "GH-G"; } }

        public static string RandomTokenProductId {
            get {
                return _tokenProductIds[new Random(DateTime.Now.Millisecond).Next(0, _tokenProductIds.Length - 1)];
            }
        }
        public static string RandomBillingPlanByProduct(string productId) {
            if (_billingPlanIds == null) {
                InitBillingPlans();
            }

            var billingPlans = _billingPlanIds.FirstOrDefault(p => p.Key == productId).Value.ToArray();
            if (billingPlans != null) {
                return billingPlans[new Random(DateTime.Now.Millisecond).Next(0, billingPlans.Length - 1)];
            }
            return null;
        }

        public static ShoppingCartItem GetTokenShoppingCartItem() {
            return GetTokenShoppingCartItem(RandomTokenProductId, DateTime.Today);
        }
        public static ShoppingCartItem GetTokenShoppingCartItem(string productId) {
            return GetTokenShoppingCartItem(productId, DateTime.Today);
        }
        public static ShoppingCartItem GetTokenShoppingCartItem(string productId, DateTime startDate) {
            var item = new ShoppingCartItem() {
                BillingPlanID = RandomBillingPlanByProduct(productId),
                ProductID = productId,
                Quantity = 1,
                SubscriptionStartDate = DateTime.Today.AddDays(1),
            };            

            return item;
        }

        private static void InitBillingPlans() {
            _billingPlanIds = new Dictionary<string, List<string>>();
            _billingPlanIds.Add("CP", new List<string>());
            _billingPlanIds["CP"].Add("CP-6M-NR");
            _billingPlanIds["CP"].Add("CP-1M-S");
            _billingPlanIds["CP"].Add("CP-3M-S");
            _billingPlanIds["CP"].Add("CP-6M-S");
            _billingPlanIds["CP"].Add("CP-12M-SP");

            _billingPlanIds.Add("GH", new List<string>());
            _billingPlanIds["GH"].Add("GH-T");
            _billingPlanIds["GH"].Add("GH-1M-P");
            _billingPlanIds["GH"].Add("GH-3M-P");
            _billingPlanIds["GH"].Add("GH-6M-P");
            _billingPlanIds["GH"].Add("GH-12M-P");

            _billingPlanIds.Add("CP-G", new List<string>());
            _billingPlanIds["CP-G"].Add("CP-1M-G");
            _billingPlanIds["CP-G"].Add("CP-3M-G");
            _billingPlanIds["CP-G"].Add("CP-6M-G");
            _billingPlanIds["CP-G"].Add("CP-12M-G");

            _billingPlanIds.Add("VH", new List<string>());
            _billingPlanIds["VH"].Add("VH25-1M-S");
            _billingPlanIds["VH"].Add("VH25-3M-S");
            _billingPlanIds["VH"].Add("VH25-6M-S");
            _billingPlanIds["VH"].Add("VH25-12M-S");
            _billingPlanIds["VH"].Add("VH10-1M-S");
            _billingPlanIds["VH"].Add("VH10-3M-S");
            _billingPlanIds["VH"].Add("VH10-6M-S");
            _billingPlanIds["VH"].Add("VH10-12M-S");
            _billingPlanIds["VH"].Add("VH50-1M-S");
            _billingPlanIds["VH"].Add("VH50-3M-S");
            _billingPlanIds["VH"].Add("VH50-6M-S");
            _billingPlanIds["VH"].Add("VH50-12M-S");
            _billingPlanIds["VH"].Add("VH100-1M-S");
            _billingPlanIds["VH"].Add("VH100-3M-S");
            _billingPlanIds["VH"].Add("VH100-6M-S");
            _billingPlanIds["VH"].Add("VH100-12M-S");
            _billingPlanIds["VH"].Add("VH25-T");
            _billingPlanIds["VH"].Add("VH50-T");
            _billingPlanIds["VH"].Add("VH100-T");
            _billingPlanIds["VH"].Add("VH10-T-LIVE");

            _billingPlanIds.Add("GHV", new List<string>());
            _billingPlanIds["GHV"].Add("GHV10-1M-S");
            _billingPlanIds["GHV"].Add("GHV10-3M-S");
            _billingPlanIds["GHV"].Add("GHV10-6M-S");
            _billingPlanIds["GHV"].Add("GHV25-1M-S");
            _billingPlanIds["GHV"].Add("GHV25-3M-S");
            _billingPlanIds["GHV"].Add("GHV10-12M-S");
            _billingPlanIds["GHV"].Add("GHV25-6M-S");
            _billingPlanIds["GHV"].Add("GHV25-12M-S");
            _billingPlanIds["GHV"].Add("GHV50-1M-S");
            _billingPlanIds["GHV"].Add("GHV50-3M-S");
            _billingPlanIds["GHV"].Add("GHV50-6M-S");
            _billingPlanIds["GHV"].Add("GHV50-12M-S");
            _billingPlanIds["GHV"].Add("GHV100-1M-S");
            _billingPlanIds["GHV"].Add("GHV100-3M-S");
            _billingPlanIds["GHV"].Add("GHV100-6M-S");
            _billingPlanIds["GHV"].Add("GHV100-12M-S");

            _billingPlanIds.Add("GHT-1", new List<string>());
            _billingPlanIds["GHT-1"].Add("GHT-1");

            _billingPlanIds.Add("VHT-2", new List<string>()); 
            _billingPlanIds["VHT-2"].Add("VHT-2");

            _billingPlanIds.Add("GHT-15", new List<string>());
            _billingPlanIds["GHT-15"].Add("GHT-15");

            _billingPlanIds.Add("GHT-30", new List<string>());
            _billingPlanIds["GHT-30"].Add("GHT-30");

            _billingPlanIds.Add("GHT-90", new List<string>());
            _billingPlanIds["GHT-90"].Add("GHT-90");

            _billingPlanIds.Add("GHT-180", new List<string>());
            _billingPlanIds["GHT-180"].Add("GHT-180");

            _billingPlanIds.Add("GHT-360", new List<string>());
            _billingPlanIds["GHT-360"].Add("GHT-360");

            _billingPlanIds.Add("GHT-G", new List<string>());
            _billingPlanIds["GHT-G"].Add("GH-1M-G");
        }
    }
}
