﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ServiceUnitTests.AuthService;
using Vindicia;
using Curse.Billing.Data;
//using Curse.Billing.Models;
using System.IO;
using ServiceUnitTests.BillingService;
using Curse.Billing.Models;

namespace ServiceUnitTests.Common {
    public static class Utilities {
        static NetworkServiceSoapClient _authClient;
        static NetworkServiceSoapClient AuthClient {
            get {
                if (_authClient == null) {
                    _authClient = new NetworkServiceSoapClient();
                }

                return _authClient;
            }
        }
        static BillingServiceClient _billingClient;
        static BillingServiceClient BillingClient {
            get {
                if (_billingClient == null) {
                    _billingClient = new BillingServiceClient();
                }

                return _billingClient;
            }
        }


        static string[] _productIds = new string[] {"CP", "GH", "CP-G", "VH", "GHV", "GHT-1", "VHT-2", "GHT-15", "GHT-30", "GHT-90", "GHT-180", "GHT-360", "GH-G" };

        #region Auth Functions
        public static int CreateUser(int siteid, string username, string password, string firstname, string lastname, string birthdate, string gender, string emailaddress) {
            AddUserResult result = AuthClient.v2AddUser(
                siteid,
                username,
                password,
                firstname,
                lastname,
                birthdate,
                gender,
                "US",
                "AL",
                "Huntsville",
                emailaddress,
                false,
                "From",
                "Redirect",
                "Session"
            );

            if (result.Status == EAddUserStatus.Successful) {
                return result.UserID;
            }

            return 0;
        }
        public static int CreateLegacyUser(int siteid, int legacyid, string username, string password, string firstname, string lastname, string birthdate, string gender, string emailaddress) {
            AddUserResult result = AuthClient.v2AdminAddLegacyUser(
                siteid,
                legacyid,
                username,
                password,
                firstname,
                lastname,
                birthdate,
                gender,
                "US",
                "AL",
                "Huntsville",
                emailaddress,
                false,
                "From",
                "Redirect",
                "Session"
            );

            if (result.Status == EAddUserStatus.Successful) {
                return result.UserID;
            }

            return 0;
        }
        public static bool DeleteUser(int siteId, int userId) {
            DeleteUserResult result = AuthClient.v2AdminDeleteUser(siteId, userId);
            return (result.Status == EDeleteUserStatus.Success);
        }
        #endregion

        #region Billing Functions
        public static void CreateBillingAccount(int siteid, int userId) {
            var user = AuthClient.v2GetUserProfile(siteid, userId);
            if (user != null) {
                CreateBillingAccount(user);
            }
        }
        public static void CreateBillingAccount(User user) {
            var accountInfo = new AccountInformation() {
                ID = "U-" + user.ID,
                Name = user.Name,
                Company = "Curse Inc.",
                EmailAddress = user.Profile.Emails.First(p => p.ID == user.Profile.PrimaryEmail).Address
            };

            BillingClient.CreateOrUpdateAccount(accountInfo); 
        }
        public static bool CancelSubscription(int userId, string accountId, string subscriptionId) {
            var result = BillingClient.CancelSubscription(userId, accountId, subscriptionId, string.Empty);
            return (result.Status == ServiceResponseStatus.Successful);
        }
        #endregion
    }
}
