﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ServiceUnitTests.BillingService;
using System.Data.SqlClient;
using Curse.Billing.Models;

namespace ServiceUnitTests.Extensions {
    public static class SubscriptionExtensions {
        public static void SetFromDataReader(this Subscription sub, SqlDataReader reader) {
            sub.SubscriptionID = reader.GetString(1);
            sub.AccountID = reader.GetString(2);
            sub.ProductID = reader.GetString(3);
            sub.BillingPlanID = reader.GetString(4);
            sub.DateStarted = reader.GetDateTime(6);
            sub.DateExpires = reader.GetDateTime(7);
            sub.DateUpdated = reader.GetDateTime(8);
            sub.Status = (SubscriptionStatus)reader.GetByte(12);

            if (!reader.IsDBNull(5)) {
                sub.PaymentMethodID = reader.GetString(5);
            }
            if (reader[9] != System.DBNull.Value) {
                sub.NextBillingDate = reader.GetDateTime(9);
            }

            if (reader[10] != System.DBNull.Value) {
                sub.NextBillAmount = reader.GetDecimal(10);
            }

            if (reader[11] != System.DBNull.Value) {
                sub.NextBillCurrency = reader.GetString(11);
            }

            if (reader[13] != DBNull.Value) {
                sub.DateCancelled = reader.GetDateTime(13);
            }            
        }
    }
}
