﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using System.Data.SqlClient;
using System.Configuration;
using ServiceUnitTests.AuthService;
using ServiceUnitTests.Attributes;

namespace ServiceUnitTests.TestFixtures {
    [TestFixture]
    [AuthServiceCategory]
    abstract class AuthTestFixture : BaseTestFixture {
        NetworkServiceSoapClient _client;
        int _userid;
        int _siteid;
        string _existingUserName;
        string _existingEmail;

        protected NetworkServiceSoapClient AuthClient { get { return _client; } }
        protected int CurseSiteID { get { return _siteid; } }
        protected int UserID { get { return _userid; } }
        protected string ExistingUserName {
            get {
                if (string.IsNullOrEmpty(_existingUserName)) {
                    using (var conn = new SqlConnection(AuthConnectionString)) {
                        var cmd = new SqlCommand("SELECT TOP 1 _username FROM users ORDER BY _uid DESC", conn);

                        conn.Open();
                        _existingUserName = (string)cmd.ExecuteScalar();
                    }
                }

                return _existingUserName;
            }
        }
        protected string ExistingEmail {
            get {
                if (string.IsNullOrEmpty(_existingEmail)) {
                    using (var conn = new SqlConnection(AuthConnectionString)) {
                        var cmd = new SqlCommand("SELECT TOP 1 _email FROM useremails", conn);

                        conn.Open();
                        _existingEmail = (string)cmd.ExecuteScalar();
                    }
                }

                return _existingEmail;
            }
        }

        #region Constants
        protected string Username = "unitTestAccount";
        protected string InvalidUsername = Guid.NewGuid().ToString();
        protected string RandomUsername {
            get {
                var name = Guid.NewGuid().ToString();
                return name.Substring(0, 10).Replace("-", "");
            }
        }
        protected string CurseEncPassword = "zjBDELEjhd16GjKlBQ==";
        protected string InvalidPassword = "8R46T+5735A3";
        protected string BirthDate = "1977-09-12";
        protected string InvalidBirthDay = "12-SEP-1977";
        protected string FirstName = "Firstname";
        protected string LastName = "Lastname";
        protected string InvalidName = "b";
        protected string Gender {
            get {
                return new Random().Next(1, 2).ToString();
            }
        }
        protected string InvalidGender = "male";
        protected string Country = "US";
        protected string Region = "AL";
        protected string City = "Huntsville";
        protected string EmailAddress = "newemail@curse.com";
        protected string RandomEmailAddress {
            get {
                var email = Guid.NewGuid().ToString();
                return email.Substring(0, 5).Replace("-", "") + "@curse.com";
            }
        }
        protected string InvalidEmail = "notAnEmailAddress";
        protected bool NewsLetter {
            get {
                return (new Random().Next(0, 1) == 1);
            }
        }
        protected int LegacyID {
            get {
                return new Random(DateTime.Now.Millisecond).Next(100000, 200000);
            }
        }
        protected string SessionID = @"1234567890123456";
        protected string InvalidSessionID = @"123456789012345";
        #endregion

        [SetUp]
        public void Init() {
            _client = new NetworkServiceSoapClient();
            _siteid = Int32.Parse(ConfigurationManager.AppSettings["SiteId"]);

            #region Get a random valid user id
            //using (var conn = new SqlConnection(AuthConnectionString)) {
            //    var cmd = new SqlCommand("SELECT MAX(_uid) FROM users WHERE _status = 0", conn);

            //    conn.Open();
            //    _userid = (int)cmd.ExecuteScalar();
            //}
            //Assert.IsNotNull(_userid, "_userid is null");
            //Assert.AreNotEqual(default(int), _userid);
            #endregion
        }//setup
    }
}
