﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using ServiceUnitTests.Attributes;
using ServiceUnitTests.GameServerService;
using System.Configuration;

namespace ServiceUnitTests.TestFixtures
{
    [TestFixture]
    [GameServerServiceCategoryAttribute]
    abstract class GameServerTestFixture : BaseTestFixture
    {
        GameServerServiceClient _client;
        public GameServerServiceClient Client { get { return _client; } }

        string _dbConnectionString;
        public string DbConnectionString { get { return _dbConnectionString; } }

        public GameServerTestFixture()
        {
            _client = new GameServerServiceClient();

            _dbConnectionString = ConfigurationManager.ConnectionStrings["GameServerDB"].ConnectionString;
        }
    }
}
