﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ServiceUnitTests.TestFixtures;
using ServiceUnitTests.Attributes;
using NUnit.Framework;
using ServiceUnitTests.AuthService;

namespace ServiceUnitTests.UnitTests.AuthService
{
    [AuthUnitTests]
    class LegacyUserMigration : AuthTestFixture
    {
        [Test]
        public void MerrilandUserMigration()
        {
            //mortymix@morton.zzn.com/MistressBeverly
            //AuthClient.v2ValidateWebUser(7777788, "mortymix@morton.zzn.com", "F5fRAvCgGbkTOpDZFpg=", "Session");

            //sanktanglia2/nic857462/I8zQXfSvOYAqAKyNFQ==
            var result = AuthClient.v2ValidateClientUser(7777788, "sanktanglia2", "I8zQXfSvOYAqAKyNFQ==");
            Assert.AreEqual(ELoginStatus.Success, result.Status);
        }

        [Test]
        public void MtgSalvationUserMigration()
        {
            var result = AuthClient.v2ValidateClientUser(7777788, "reverett_mtg", "gA/jfNaLEPoAZJr4Mb4=");
            Assert.AreEqual(ELoginStatus.Success, result.Status);
        }

        [Test]
        public void v2AdminAddLegacyUser()
        {
            var result = AuthClient.v2AdminAddLegacyUser(7777788, 1, RandomUsername, "something", FirstName, LastName, BirthDate, Gender, Country, Region, City, RandomEmailAddress, false, null, null, null);
            Assert.AreEqual(EAddUserStatus.Successful, result.Status);
        }

        [Test]
        public void v3AdminAddLegacyUser()
        {
            //0f16f8596a3d92444a7c03586139a900
            //scUzON^V\Vo=IZPrn~XVfpendv%wJ1
            //var result = AuthClient.v3AdminAddLegacyUser(7777788, 1, @"scUzON^V\Vo=IZPrn~XVfpendv%wJ1", ELegacyEncryptionType.vBulletin, "reverett_mtg", "0f16f8596a3d92444a7c03586139a900", FirstName, LastName, BirthDate, Gender, Country, Region, City, RandomEmailAddress, false, null, null, DateTime.Parse("1977/09/12"), "session");
            var result = AuthClient.v3AdminAddLegacyUser(7777788, 999999999, @"scUzON^V\Vo=IZPrn~XVfpendv%wJ1", ELegacyEncryptionType.vBulletin, "m_deathbringer", "0f16f8596a3d92444a7c03586139a900", "     ", string.Empty, "1900-01-01", string.Empty, "US", string.Empty, string.Empty, "m_deathbringer@hotmail.com", false, null, null, DateTime.Parse("1977/09/12"), "session");
            Assert.AreEqual(EAddUserStatus.Successful, result.Status);
        }

        [Test]
        public void v2GetUserIDFromEmail()
        {
            var result = AuthClient.v2GetUserIDFromEmail(9999005, "goblinboy@gmail.com");
            Assert.AreNotEqual(0, result);
        }
    }
}
