﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ServiceUnitTests.TestFixtures;
using NUnit.Framework;
using System.Data.SqlClient;
using System.Data;
using ServiceUnitTests.AuthService;
using ServiceUnitTests.Attributes;

namespace ServiceUnitTests.UnitTests.AuthService {
    [AuthUnitTests]
    class SubscriptionTests : AuthTestFixture {
        #region static variables
        private static int _siteId = 6666666;
        private static int _userid = 792;
        #endregion

        [TearDown]
        public void Reset() {
            using (var conn = new SqlConnection(AuthConnectionString)) {
                var cmd = new SqlCommand("delete from usersubscriptions where _uid = @uid", conn);
                cmd.Parameters.Add("uid", SqlDbType.Int).Value = _userid;

                conn.Open();
                cmd.ExecuteNonQuery();
            }
        }

        #region Tests
        [Test]
        public void AddSubcriptionCredit() {
            var response = AuthClient.v2AddSubscriptionCredit(_siteId, _userid, 1, 1, 0);
            if (response == EAddSubscriptionCreditStatus.Success) {
                using (var conn = new SqlConnection(AuthConnectionString)) {
                    var cmd = new SqlCommand("select count(0) from usersubscriptions where _uid = @uid and _active = 1", conn);
                    cmd.Parameters.Add("uid", SqlDbType.Int).Value = _userid;

                    conn.Open();
                    int count = (int)cmd.ExecuteScalar();
                    Assert.GreaterOrEqual(count, 1);
                }
            }
        }

        [Test]
        public void AddSubcriptionCreditWithUnknownUser() {
            var response = AuthClient.v2AddSubscriptionCredit(_siteId, -1, 1, 1, 0);
            Assert.AreEqual(EAddSubscriptionCreditStatus.UserNotFound, response);
        }

        [Test]
        public void AddSubcriptionCreditWithUnknownSite() {
            var response = AuthClient.v2AddSubscriptionCredit(-1, _userid, 1, 1, 0);
            Assert.AreEqual(EAddSubscriptionCreditStatus.InvalidNetworkSite, response);
        }

        [Test]
        public void SetPremiumExpiration() {
            var expiration = DateTime.UtcNow.AddMonths(1);

            var response = AuthClient.v2SetPremiumExpiration(_siteId, _userid, expiration, 0);
            if (response == ESetPremiumExpirationStatus.Success) {
                using (var conn = new SqlConnection(AuthConnectionString)) {
                    var cmd = new SqlCommand("select count(0) from usersubscriptions where _uid = @uid and _expiration = @expiration", conn);
                    cmd.Parameters.Add("uid", SqlDbType.Int).Value = _userid;
                    cmd.Parameters.Add("expiration", SqlDbType.DateTime).Value = expiration;

                    conn.Open();
                    int count = (int)cmd.ExecuteScalar();
                    Assert.GreaterOrEqual(count, 1);
                }
            }
        }

        [Test]
        public void SetPremiumExpirationWithUnknownUser() {
            var response = AuthClient.v2SetPremiumExpiration(_siteId, -1, DateTime.UtcNow.AddMonths(1), 0);
            Assert.AreEqual(ESetPremiumExpirationStatus.UserNotFound, response);
        }

        [Test]
        public void SetPremiumExpirationWithUnknownSite() {
            var response = AuthClient.v2SetPremiumExpiration(-1, _userid, DateTime.UtcNow.AddMonths(1), 0);
            Assert.AreEqual(ESetPremiumExpirationStatus.InvalidNetworkSite, response);
        }
        #endregion
    }
}
