﻿using System;
using System.Data;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ServiceUnitTests.Attributes;
using NUnit.Framework;
using System.Data.SqlClient;
using ServiceUnitTests.TestFixtures;

namespace ServiceUnitTests.UnitTests.AzerothService
{
    [AzerothUnitTests]
    public class AggrigationTests : AzerothServiceTestFixture
    {
        #region Aggrigation
        [Test]
        public void Drop()
        {
            using (var conn = new SqlConnection(DbConnectionString))
            {
                var cmd = new SqlCommand("spAggregateDropData", conn);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandTimeout = Int32.MaxValue;

                try
                {
                    conn.Open();
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException exc)
                {
                    Assert.Fail(exc.Message);
                }
            }

            Assert.Pass();
        }

        [Test]
        public void DropCount()
        {
            using (var conn = new SqlConnection(DbConnectionString))
            {
                var cmd = new SqlCommand("spAggregateDropCountData", conn);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandTimeout = Int32.MaxValue;

                try
                {
                    conn.Open();
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException exc)
                {
                    Assert.Fail(exc.Message);
                }
            }

            Assert.Pass();
        }

        [Test]
        public void ItemBlackMarket()
        {
            using (var conn = new SqlConnection(DbConnectionString))
            {
                var cmd = new SqlCommand("spAggregateItemBlackMarketData", conn);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandTimeout = Int32.MaxValue;

                try
                {
                    conn.Open();
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException exc)
                {
                    Assert.Fail(exc.Message);
                }
            }

            Assert.Pass();
        }

        [Test]
        public void ItemDurability()
        {
            using (var conn = new SqlConnection(DbConnectionString))
            {
                var cmd = new SqlCommand("spAggregateItemDurabilityData", conn);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandTimeout = Int32.MaxValue;

                try
                {
                    conn.Open();
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException exc)
                {
                    Assert.Fail(exc.Message);
                }
            }

            Assert.Pass();
        }

        [Test]
        public void Location()
        {
            using (var conn = new SqlConnection(DbConnectionString))
            {
                var cmd = new SqlCommand("spAggregateLocationData", conn);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandTimeout = Int32.MaxValue;

                try
                {
                    conn.Open();
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException exc)
                {
                    Assert.Fail(exc.Message);
                }
            }

            Assert.Pass();
        }

        [Test]
        public void NpcReaction()
        {
            using (var conn = new SqlConnection(DbConnectionString))
            {
                var cmd = new SqlCommand("spAggregateNpcReactionData", conn);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandTimeout = Int32.MaxValue;

                try
                {
                    conn.Open();
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException exc)
                {
                    Assert.Fail(exc.Message);
                }
            }

            Assert.Pass();
        }

        [Test]
        public void NpcReputation()
        {
            using (var conn = new SqlConnection(DbConnectionString))
            {
                var cmd = new SqlCommand("spAggregateNpcReputationData", conn);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandTimeout = Int32.MaxValue;

                try
                {
                    conn.Open();
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException exc)
                {
                    Assert.Fail(exc.Message);
                }
            }

            Assert.Pass();
        }

        [Test]
        public void NpcSpell()
        {
            using (var conn = new SqlConnection(DbConnectionString))
            {
                var cmd = new SqlCommand("spAggregateNpcSpellData", conn);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandTimeout = Int32.MaxValue;

                try
                {
                    conn.Open();
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException exc)
                {
                    Assert.Fail(exc.Message);
                }
            }

            Assert.Pass();
        }

        [Test]
        public void NpcStat()
        {
            using (var conn = new SqlConnection(DbConnectionString))
            {
                var cmd = new SqlCommand("spAggregateNpcStatData", conn);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandTimeout = Int32.MaxValue;

                try
                {
                    conn.Open();
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException exc)
                {
                    Assert.Fail(exc.Message);
                }
            }

            Assert.Pass();
        }

        [Test]
        public void NpcTeach()
        {
            using (var conn = new SqlConnection(DbConnectionString))
            {
                var cmd = new SqlCommand("spAggregateNpcTeachData", conn);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandTimeout = Int32.MaxValue;

                try
                {
                    conn.Open();
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException exc)
                {
                    Assert.Fail(exc.Message);
                }
            }

            Assert.Pass();
        }

        [Test]
        public void QuestCompletedByClass()
        {
            using (var conn = new SqlConnection(DbConnectionString))
            {
                var cmd = new SqlCommand("spAggregateQuestCompletedByClassData", conn);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandTimeout = Int32.MaxValue;

                try
                {
                    conn.Open();
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException exc)
                {
                    Assert.Fail(exc.Message);
                }
            }

            Assert.Pass();
        }

        [Test]
        public void QuestCompletedByRace()
        {
            using (var conn = new SqlConnection(DbConnectionString))
            {
                var cmd = new SqlCommand("spAggregateQuestCompletedByRaceData", conn);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandTimeout = Int32.MaxValue;

                try
                {
                    conn.Open();
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException exc)
                {
                    Assert.Fail(exc.Message);
                }
            }

            Assert.Pass();
        }

        [Test]
        public void Quest()
        {
            using (var conn = new SqlConnection(DbConnectionString))
            {
                var cmd = new SqlCommand("spAggregateQuestData", conn);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandTimeout = Int32.MaxValue;

                try
                {
                    conn.Open();
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException exc)
                {
                    Assert.Fail(exc.Message);
                }
            }

            Assert.Pass();
        }

        [Test]
        public void SpellRequiredLevel()
        {
            using (var conn = new SqlConnection(DbConnectionString))
            {
                var cmd = new SqlCommand("spAggregateSpellRequiredLevelData", conn);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandTimeout = Int32.MaxValue;

                try
                {
                    conn.Open();
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException exc)
                {
                    Assert.Fail(exc.Message);
                }
            }

            Assert.Pass();
        }

        [Test]
        public void SpellRequiredProfessionLevel()
        {
            using (var conn = new SqlConnection(DbConnectionString))
            {
                var cmd = new SqlCommand("spAggregateSpellRequiredProfessionLevelData", conn);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandTimeout = Int32.MaxValue;

                try
                {
                    conn.Open();
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException exc)
                {
                    Assert.Fail(exc.Message);
                }
            }

            Assert.Pass();
        }

        [Test]
        public void VendorItems()
        {
            using (var conn = new SqlConnection(DbConnectionString))
            {
                var cmd = new SqlCommand("spAggregateVendorItemsData", conn);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandTimeout = Int32.MaxValue;

                try
                {
                    conn.Open();
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException exc)
                {
                    Assert.Fail(exc.Message);
                }
            }

            Assert.Pass();
        }

        [Test]
        public void ProfessionSkillDiscovery() 
        {
            using (var conn = new SqlConnection(DbConnectionString))
            {
                var cmd = new SqlCommand("spAggregateProfessionSkillDiscoveryData", conn);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.CommandTimeout = Int32.MaxValue;

                try
                {
                    conn.Open();
                    cmd.ExecuteNonQuery();
                }
                catch (SqlException exc)
                {
                    Assert.Fail(exc.Message);
                }
            }

            Assert.Pass();
        }
#endregion
    }

    [AzerothUnitTests]
    public class BatchDeletionRoutines : AzerothServiceTestFixture
    {
        #region BatchDelete routines
        [Test]
        public void DeleteDropData()
        {
            using (SqlConnection conn = new SqlConnection(DbConnectionString))
            {
                Assert.AreEqual(true, DeleteTableData("Drop", conn));
            }
        }

        [Test]
        public void DeleteDropCountData()
        {
            using (SqlConnection conn = new SqlConnection(DbConnectionString))
            {
                Assert.AreEqual(true, DeleteTableData("DropCount", conn));
            }
        }

        [Test]
        public void DeleteItemBlackMarketData()
        {
            using (SqlConnection conn = new SqlConnection(DbConnectionString))
            {
                Assert.AreEqual(true, DeleteTableData("ItemBlackMarket", conn));
            }
        }

        [Test]
        public void DeleteItemDurabilityData()
        {
            using (SqlConnection conn = new SqlConnection(DbConnectionString))
            {
                Assert.AreEqual(true, DeleteTableData("ItemDurability", conn));
            }
        }

        [Test]
        public void DeleteLocationData()
        {
            using (SqlConnection conn = new SqlConnection(DbConnectionString))
            {
                Assert.AreEqual(true, DeleteTableData("Location", conn));
            }
        }

        [Test]
        public void DeleteNpcReactionData()
        {
            using (SqlConnection conn = new SqlConnection(DbConnectionString))
            {
                Assert.AreEqual(true, DeleteTableData("NpcReaction", conn));
            }
        }

        [Test]
        public void DeleteNpcReputationData()
        {
            using (SqlConnection conn = new SqlConnection(DbConnectionString))
            {
                Assert.AreEqual(true, DeleteTableData("NpcReputation", conn));
            }
        }

        [Test]
        public void DeleteNpcSpellData()
        {
            using (SqlConnection conn = new SqlConnection(DbConnectionString))
            {
                Assert.AreEqual(true, DeleteTableData("NpcSpell", conn));
            }
        }

        [Test]
        public void DeleteNpcTeachData()
        {
            using (SqlConnection conn = new SqlConnection(DbConnectionString))
            {
                Assert.AreEqual(true, DeleteTableData("NpcTeach", conn));
            }
        }

        [Test]
        public void DeleteQuestClassData()
        {
            using (SqlConnection conn = new SqlConnection(DbConnectionString))
            {
                Assert.AreEqual(true, DeleteTableData("QuestClass", conn));
            }
        }

        [Test]
        public void DeleteQuestRaceData()
        {
            using (SqlConnection conn = new SqlConnection(DbConnectionString))
            {
                Assert.AreEqual(true, DeleteTableData("QuestRace", conn));
            }
        }

        [Test]
        public void DeleteSpellRequiredLevelData()
        {
            using (SqlConnection conn = new SqlConnection(DbConnectionString))
            {
                Assert.AreEqual(true, DeleteTableData("SpellRequiredLevel", conn));
            }
        }

        [Test]
        public void DeleteTradeSkillRequirementData()
        {
            using (SqlConnection conn = new SqlConnection(DbConnectionString))
            {
                Assert.AreEqual(true, DeleteTableData("TradeSkillRequirement", conn));
            }
        }

        [Test]
        public void DeleteVendorItemsData()
        {
            using (SqlConnection conn = new SqlConnection(DbConnectionString))
            {
                Assert.AreEqual(true, DeleteTableData("VendorItems", conn));
            }
        }

        [Test]
        public void DeleteNpcStatsData()
        {
            using (SqlConnection conn = new SqlConnection(DbConnectionString))
            {
                Assert.AreEqual(true, DeleteTableData("NpcStats", conn));
            }
        }

        [Test]
        public void DeleteQuestData()
        {
            using (SqlConnection conn = new SqlConnection(DbConnectionString))
            {
                Assert.AreEqual(true, DeleteTableData("Quest", conn));
            }
        }

        [Test]
        public void DeleteProfessionSkillDiscoveryData()
        {
            using (SqlConnection conn = new SqlConnection(DbConnectionString))
            {
                Assert.AreEqual(true, DeleteTableData("ProfessionSkillDiscovery", conn));
            }
        }

        private int GetTableCount(string tableName, SqlConnection conn)
        {
            var cmd = new SqlCommand(string.Format("SELECT Count(1) FROM [{0}] WHERE DateCreated <= (SELECT LastRunTime FROM AggregateRunTimes WHERE TableName = '{0}')", tableName), conn);
            if (conn.State != ConnectionState.Open)
            {
                conn.Open();
            }

            return (int)cmd.ExecuteScalar();
        }
        private bool DeleteTableData(string tableName, SqlConnection conn)
        {
            int rowCount = GetTableCount(tableName, conn);

            var cmd = new SqlCommand(string.Format("DELETE TOP(100000) FROM [{0}] WHERE DateCreated <= (SELECT LastRunTime FROM AggregateRunTimes WHERE TableName = '{0}')", tableName), conn);
            cmd.CommandTimeout = Int32.MaxValue;

            try
            {
                if (conn.State != ConnectionState.Open)
                {
                    conn.Open();
                }

                while (rowCount > 0)
                {
                    cmd.ExecuteNonQuery();
                    rowCount -= 100000;
                }

                return true;
            }
            catch (SqlException exc)
            {
                return false;
            }
        }
        #endregion
    }
}
