﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ServiceUnitTests.TestFixtures;
using ServiceUnitTests.Attributes;
using NUnit.Framework;
using ServiceUnitTests.BillingService;
using Curse.Billing.Models;

namespace ServiceUnitTests.UnitTests.BillingService {
    [BillingUnitTests]
    class AccountTests : BillingTestFixture {
        [Test]
        public void CreateOrUpdateAccount() {
            var accountInfo = new AccountInformation() {
                ID = "U-" + UserID,
                Name = "Automation",
                Company = "Curse Inc.",
                EmailAddress = "automation@curse.com",
                Address = new AccountAddress() {
                    Address1 = "301 Church St.",
                    City = "Huntsville",
                    District = "AL",
                    Country = "US",
                    PostalCode = "35806"
                },
                PreferredCurrency = CurrencyType.Token
            };

            var result = Client.CreateOrUpdateAccount(accountInfo); 
            Assert.AreEqual(ServiceResponseStatus.Successful, result.Status);
        }
    }
}
