﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ServiceUnitTests.TestFixtures;
using System.Configuration;
using System.Data.SqlClient;
using System.Data;
using NUnit.Framework;
using ServiceUnitTests.Attributes;
using ServiceUnitTests.BillingService;
using Curse.Billing.Models;

namespace ServiceUnitTests.UnitTests.BillingService {
    [BillingUnitTests]
    class CouponTests : BillingTestFixture {
        //Variables
        private const string goodAccountID = "U-4735982-JasonTest008";
        private const string badAccountID = "BadAccount@curse.com";
        private const string goodCoupon = "3B9F-2FB9-6929-4AC9";
        private const string expiredCoupon = "8329-C246-EABF-45FA";

        [TearDown]
        public void ResetCoupon() {
            using (SqlConnection conn = new SqlConnection(BillingConnectionString)) {
                //Reset the good barcode
                var cmd = conn.CreateCommand();
                cmd.CommandText = "delete from CouponUsage where CouponID = (select ID from Coupon where Code = @Code)";
                cmd.Parameters.Add("Code", SqlDbType.VarChar, 64).Value = goodCoupon;

                conn.Open();
                cmd.ExecuteNonQuery();

                //reset the expired coupon
                cmd.Parameters["Code"].Value = expiredCoupon;
                cmd.ExecuteNonQuery();
            }//using connection
        }//reset the coupons

        [Test]
        public void ValidateGoodCoupon() {
            ServiceResponse response = Client.ValidateCoupon(goodCoupon, goodAccountID);
            Assert.AreEqual(ServiceResponseStatus.Successful, response.Status);
        }//Validate Good Coupon with good account

        [Test]
        public void ValidateBadCoupon() {
            ServiceResponse response = Client.ValidateCoupon("this-is-not-a-coupon", goodAccountID);
            Assert.AreEqual(ServiceResponseStatus.ClaimCoupon_CodeNotFound, response.Status);
        }//validate a non-exisitng barcode

        [Test]
        public void ValidateExpiredCoupon() {
            ServiceResponse response = Client.ValidateCoupon(expiredCoupon, goodAccountID);
            Assert.AreEqual(ServiceResponseStatus.ClaimCoupon_CodeExpired, response.Status);
        }//Validate Expired Coupon

        [Test]
        public void ValidateCouponWithBadAccount() {
            ServiceResponse response = Client.ValidateCoupon(goodCoupon, badAccountID);
            Assert.AreEqual(ServiceResponseStatus.ClaimCoupon_CodeAlreadyClaimed, response.Status);
        }//Validate good coupon with good account

        [Test]
        public void ClaimCouponWithGoodAccount() {
            ServiceResponse response = Client.ClaimCoupon(0, 0, 0, 0, goodCoupon, goodAccountID);
            Assert.AreEqual(ServiceResponseStatus.Successful, response.Status);
        }//claim a good coupon with a good account

        [Test]
        public void ClaimCouponWithInvalidAccount() {
            ServiceResponse response = Client.ClaimCoupon(0, 0, 0, 0, goodCoupon, badAccountID);
            Assert.AreEqual(ServiceResponseStatus.AccountNotFound, response.Status);
        }//claim coupon with a bad account
    }//CouponTests    
}
