﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using ServiceUnitTests.TestFixtures;
using ServiceUnitTests.Attributes;
using ServiceUnitTests.BillingService;
using ServiceUnitTests.Common;
using System.Data.SqlClient;
using Curse.Billing.Models;

namespace ServiceUnitTests.UnitTests.BillingService {
    [BillingUnitTests]
    class SubscriptionTests : BillingTestFixture {
        int _cobaltInstanceId = 2, _entityTypeId, _entityId;
                
        Subscription _currentSub;
        public Subscription CurrentSubscription {
            get {
                if (_currentSub == null) {
                    var response = Client.GetSubscriptionByID(ActiveSubscription.SubscriptionID);
                    if (response != null) {
                        _currentSub = response.Value;
                    }
                    else Assert.Inconclusive("Failed to pull the active subscription from the database.");
                }

                return _currentSub;
            }
        }

        [TearDown]
        public void TearDown() {
            //using (var conn = new SqlConnection(BillingConnectionString)) {
            //    var cmd = new SqlCommand("SELECT SubscriptionID FROM Subscription WHERE AccountID = @AccountID", conn);
            //    cmd.Parameters.Add("AccountID", System.Data.SqlDbType.VarChar).Value = AccountID;

            //    conn.Open();
            //    using (var reader = cmd.ExecuteReader()) {
            //        while (reader.Read()) {
            //            Utilities.CancelSubscription(UserID, AccountID, (string)reader[0]);
            //        }
            //    }
            //}
        }

        #region CreateTokenSubscriptiopns
        [Test]
        public void CreateTokenSubscriptions() {
            var cart = new ShoppingCart();
            cart.Items = new ShoppingCartItem[] { 
                new ShoppingCartItem(){
                    ProductID = "GH",
                    BillingPlanID = "GH-T",
                    Quantity = 1,
                    SubscriptionStartDate = DateTime.Today
                }
            };
            
            var result = Client.CreateTokenSubscriptions(UserID, _cobaltInstanceId, _entityTypeId, _entityId, AccountID, cart);
            Assert.AreEqual(ServiceResponseStatus.Successful, result.Status);
        }

        [Test]
        public void CreateTokenSubscriptionsInvalidAccount() {
            var result = Client.CreateTokenSubscriptions(UserID, _cobaltInstanceId, _entityTypeId, _entityId, string.Empty, new ShoppingCart());
            Assert.AreEqual(ServiceResponseStatus.AccountNotFound, result.Status);
        }

        [Test]
        public void CreateTokenSubscriptionsInvalidProduct() {
            Assert.Inconclusive("Not Implemented.");
            //Assert.AreEqual(ServiceResponseStatus.PurchaseProducts_InvalidItems, result.Status);
        }

        [Test]
        public void CreateTokenSubscriptionsInvalidBillingPlan() {
            Assert.Inconclusive("Not Implemented.");
            //Assert.AreEqual(ServiceResponseStatus.PurchaseProducts_InvalidItems, result.Status);
        }

        [Test]
        public void CreateTokenSubscriptionsInvalidCurrency() {
            Assert.Inconclusive("Not Implemented.");
            //Assert.AreEqual(ServiceResponseStatus.PurchaseProducts_InvalidItems, result.Status);
        }
        #endregion

        [Test]
        public void CancelSubscription() {
            var result = Client.CancelSubscription(UserID, AccountID, "CUSUB-00003135", "Unit test: Cancel Subscription");
            Assert.AreEqual(ServiceResponseStatus.Successful, result.Status);
        }

        [Test]
        public void CancelSubscriptionInvalidUserID() {
            var result = Client.CancelSubscription(-1, AccountID, NewSubscription.SubscriptionID, "Unit test: Cancel Subscription");
            Assert.AreEqual(ServiceResponseStatus.AccountNotFound, result.Status);
        }

        [Test]
        public void CancelSubscriptionInvalidAccount() {
            var result = Client.CancelSubscription(UserID, string.Empty, NewSubscription.SubscriptionID, "Unit test: Cancel Subscription");
            Assert.AreEqual(ServiceResponseStatus.AccountNotFound, result.Status);
        }

        [Test]
        public void CancelSubscriptionInvalidSubscription() {
            var result = Client.CancelSubscription(UserID, AccountID, string.Empty, "Unit test: Cancel Subscription");
            Assert.AreEqual(ServiceResponseStatus.CancelSubscription_SubscriptionNotFound, result.Status);
        }

        [Test]
        public void CancelSubscriptionWithExpiredSubscription() {
            var result = Client.CancelSubscription(UserID, AccountID, ExpiredSubscription.SubscriptionID, "Unit test: Cancel Subscription");
            Assert.AreEqual(ServiceResponseStatus.CancelSubscription_SubscriptionNotActive, result.Status);
        }

        [Test]
        public void GetSubscriptionByUserID()
        {
            var result = Client.GetSubscriptionByUserID(9169513);
            Assert.AreEqual(ServiceResponseStatus.Successful, result.Status);
        }
    }
}
