﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ServiceUnitTests.TestFixtures;
using ServiceUnitTests.Attributes;
using ServiceUnitTests.Extensions;
using Curse.CurseClient.Common;
using NUnit.Framework;
using System.ServiceModel;
using Curse.CurseClient.Common.ClientService;
using System.IO;
using Curse.ClientService.Models;
using System.Configuration;
using System.Net;

namespace ServiceUnitTests.UnitTests.ClientService
{
    [ClientUnitTests]
    class AdminTests : ClientServiceTestFixture
    {
        private static string _premiumUserName = "automationAdmin";
        private static string _premiumPassword = "automation";
        private CLoginResult _loginResult;

        [SetUp]
        public new void Init()
        {
            // Setup the service for a login
            Proxy.Username = _premiumUserName;
            Proxy.PlainTextPassword = _premiumPassword;

            // Do the actual login
            _loginResult = Proxy.LoginUser();

            PopulateAddonData();
        }

        [TearDown] // We don't want this to happen
        public new void ResetConnection() { 

        }

        [Test(Description = "This method changes the content-type to a form invalid with the binding.")] //This is an admin only call
        [ExpectedException(typeof(ProtocolException))]
        public void GetAddOnDump()
        {
            var addonId = Addons.Random().Key;
            var result = Proxy.TryCall<Stream>(delegate(CClientServiceClient svc)
            {
                return svc.GetAddOnDump(addonId);
            });
        }

        [Test] // This is an admin only function
        public void GetClientServiceStatistics()
        {
            var result = Proxy.TryCall<CServiceResponse<ServiceStatistics>>(delegate(CClientServiceClient svc)
            {
                return svc.GetServiceStatistics();
            });

            if (result != null)
            {
                var stats = result.Value;
                Assert.IsNotNull(stats);
            }
            else Assert.IsNotNull(result);
        }

        [Test] // This is an admin only function
        public void ResetAllAddonCache()
        {
            var result = Proxy.TryCall<string>(delegate(CClientServiceClient svc)
            {
                return svc.ResetAllAddonCache();
            });

            if (result != null)
            {
                switch (result)
                {
                    case "Addon cache cannot be reset: Cache is not yet built.":
                    case "Addon cache cannot be reset: Cache is currently updating.":
                        Assert.Inconclusive("Cache is either updating or not built yet");
                        break;
                    default:
                        Assert.AreEqual("Cache will now be reset.", result);
                        break;
                }
            }
            else Assert.IsNotNull(result);
        }

        [Test] // This is an admin only function
        public void ResetSingleAddonCache()
        {
            var addonId = Addons.Random().Key;
            var status = Proxy.TryCall<string>(delegate(CClientServiceClient svc)
            {
                return svc.ResetSingleAddonCache(addonId);
            });

            if (status != null)
            {
                switch (status)
                {
                    case "Addon cache cannot be reset: Cache is not yet built.":
                    case "Addon cache cannot be reset: Cache is currently updating.":
                        Assert.Inconclusive("Cache is either updating or not built yet");
                        break;
                    default:
                        Assert.AreEqual("Addon cache will be reset.", status);
                        break;
                }
            }
            else Assert.IsNotNull(status);
        }

        #region Cannot find anything which calls these functions
        [Test] // This is an admin only function
        public void GetAddonInstallCounts()
        {
            var apiKey = ConfigurationManager.AppSettings["ApiKey"];
            var request = (HttpWebRequest)WebRequest.Create("http://clientservice.curse.com/CClientService.svc/Soap11/GetAddonInstallCounts");
            request.Headers.Add("x-api-key", apiKey);
            var response = request.GetResponse();
            var contentType = response.Headers["Content-Type"];
            Assert.AreEqual(@"application/json; charset=utf-8", contentType);
        }

        [Test]
        public void ServerModSeviceCall()
        {
            var apiKey = ConfigurationManager.AppSettings["ApiKey"];
            var request = (HttpWebRequest)WebRequest.Create("http://api-server-mods.curse.local/ServerModService.svc/GetProjectIdsBySlug?slug=worldedit");
            request.Headers.Add("x-api-key", apiKey);
            var response = request.GetResponse();
            var contentType = response.Headers["Content-Type"];
            Assert.AreEqual(@"application/json; charset=utf-8", contentType);

            //StreamReader sr = new StreamReader(response.GetResponseStream());
            //var data = sr.ReadToEnd();
            //Assert.Fail(data);
        }

        [Test]
        public void ServerModSeviceCall_GetFilesByProject()
        {
            //var apiKey = ConfigurationManager.AppSettings["ApiKey"];
            //var request = (HttpWebRequest)WebRequest.Create(string.Format("http://api.curse.local/GetFilesByPorject?projectIds={0}", JSON.stringify()));
            //request.Headers.Add("x-api-key", apiKey);
            //var response = request.GetResponse();
            //var contentType = response.Headers["Content-Type"];
            //Assert.AreEqual(@"application/json; charset=utf-8", contentType);

            //StreamReader sr = new StreamReader(response.GetResponseStream());
            //var data = sr.ReadToEnd();
            //Assert.Fail(data);
        }
        #endregion


    }
}
