﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ServiceUnitTests.Attributes;
using ServiceUnitTests.TestFixtures;
using NUnit.Framework;
using System.Data.SqlClient;
using Curse.ClientService.Models;
using Curse.CurseClient.Common.ClientService;

namespace ServiceUnitTests.UnitTests.ClientService {
    [ClientUnitTests]
    class NotificationTests : ClientServiceTestFixture {
        [Test]
        public void GetNotifications() {
            var notificationIds = new List<int>();
            using (var conn = new SqlConnection(ClientServiceConnectionString)) {
                var cmd = new SqlCommand("SELECT ID FROM Notification WHERE DateExpires > GETUTCDATE()", conn);

                conn.Open();
                using (var reader = cmd.ExecuteReader()) {
                    while (reader.Read()) {
                        notificationIds.Add((int)reader[0]);
                    }
                }
            }

            foreach (var notificationId in notificationIds) {
                var result = Proxy.TryCall<List<CNotification>>(delegate(CClientServiceClient svc) {
                    return svc.GetNotifications(notificationId);
                });

                Assert.IsNotNull(result);
            }
        }
    }
}
