﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ServiceUnitTests.Attributes;
using ServiceUnitTests.TestFixtures;
using NUnit.Framework;
using Curse.ClientService.Models;
using Curse.CurseClient.Common.ClientService;
using System.ServiceModel;

namespace ServiceUnitTests.UnitTests.ClientService {
    [ClientUnitTests]
    class PremiumNegativeTests : ClientServiceTestFixture {
        [Test(Description = "Calls GetSyncProfile with a non-premium account")]
        [ExpectedException(typeof(FaultException))]
        public void GetSyncProfileNegative() {
            var result = Proxy.TryCall<CServiceResponse<List<CSyncedGameInstance>>>(delegate(CClientServiceClient svc) {
                return svc.GetSyncProfile();
            });
        }

        [Test(Description = "Calls JoinSyncGroup with a non-premium account")]
        [ExpectedException(typeof(FaultException))]
        public void JoinSyncGroupNegative() {
            var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc) {
                return svc.JoinSyncGroup(1, "namespace", new Guid().ToString(), "nothing");
            });
        }

        [Test(Description = "Calls LeaveSyncGroup with a non-premium account")]
        [ExpectedException(typeof(FaultException))]
        public void LeaveSyncGroupNegative() {
            var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc) {
                return svc.LeaveSyncGroup(1, 1, new Guid().ToString());
            });
        }

        [Test(Description = "Calls SaveSyncSnapshot with a non-premium account")]
        [ExpectedException(typeof(FaultException))]
        public void SaveSyncSnapshotNegative() {
            var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc) {
                return svc.SaveSyncSnapshot(1, new List<CSyncedAddon>());
            });
        }

        [Test(Description = "Calls SaveSyncTransactions with a non-premium account")]
        [ExpectedException(typeof(FaultException))]
        public void SaveSyncTransactionsNegative() {
            var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc) {
                return svc.SaveSyncTransactions(1, new List<CSyncTransaction>());
            });
        }
    }
}
