﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ServiceUnitTests.Attributes;
using ServiceUnitTests.TestFixtures;
using Curse.CurseClient.Common;
using NUnit.Framework;
using Curse.ClientService.Models;
using Curse.CurseClient.Common.ClientService;
using System.Data.SqlClient;

namespace ServiceUnitTests.UnitTests.ClientService {
    [ClientUnitTests]
    class PremiumTests : ClientServiceTestFixture {
        static string _premiumUserName = "automationAdmin";
        static string _premiumPassword = "automation";
        CLoginResult _loginResult;

        static int _newInstanceId = -1;
        static string _instanceName;
        static int _gameId = 1; // This should be WoW
        static string _computerName = System.Environment.MachineName;
        static string _instanceGuid = "86949835-594a-4796-a269-da1f2ab85621";
        static string _instanceLabel = "World of Warcraft";

        static string InstanceName
        {
            get
            {
                if (string.IsNullOrEmpty(_instanceName))
                {
                    _instanceName = Guid.NewGuid().ToString().Substring(0, 10);
                }
                return _instanceName;
            }
        }

        [SetUp]
        public new void Init() {
            // Setup the service for a login
            Proxy.Username = _premiumUserName;
            Proxy.PlainTextPassword = _premiumPassword;

            // Do the actual login
            _loginResult = Proxy.LoginUser();

            PopulateAddonData();
        }

        [TearDown] // We don't want this to happen
        public new void ResetConnection() { }

        [TestFixtureTearDown]
        public void DeleteNewlyCreatedGroup()
        {
            //if (_newInstanceId != -1)
            //{
            //    using (var conn = new SqlConnection(ClientServiceConnectionString))
            //    {
            //        var cmd = new SqlCommand("DELETE FROM SyncedGameInstance WHERE InstanceID = @ID", conn);
            //        cmd.Parameters.Add("ID", System.Data.SqlDbType.Int).Value = _newInstanceId;

            //        conn.Open();
            //        cmd.ExecuteNonQuery();
            //    }

            //    _newInstanceId = -1;
            //}
        }

        [Test]
        public void CreateSyncGroup() {
            var result = Proxy.TryCall<CServiceResponse<CSyncedGameInstance>>(delegate(CClientServiceClient svc) {
                return svc.CreateSyncGroup(InstanceName, _gameId, _computerName, _instanceGuid, _instanceLabel);
            });

            if (result != null) {
                if (result.Status == EServiceResponseStatus.Successful) {
                    _newInstanceId = result.Value.InstanceID;
                }
                Assert.AreEqual(EServiceResponseStatus.Successful, result.Status);
            }
            else Assert.IsNotNull(result);
        }

        [Test(Description = "Try to create an existing sync group")]
        public void CreateSyncGroupExisting() {
            var getSyncGroupResult = Proxy.TryCall<CServiceResponse<List<CSyncedGameInstance>>>(delegate(CClientServiceClient svc) {
                return svc.GetSyncProfile();
            });

            if (getSyncGroupResult != null) {
                var result = Proxy.TryCall<CServiceResponse<CSyncedGameInstance>>(delegate(CClientServiceClient svc) {
                    return svc.CreateSyncGroup(getSyncGroupResult.Value[0].InstanceName, _gameId, _computerName, _instanceGuid, _instanceLabel);
                });

                if (result != null) {
                    Assert.AreEqual(EServiceResponseStatus.CreateSyncGroup_GroupAlreadyExists, result.Status);
                }
                else Assert.IsNotNull(result);
            }
            else Assert.Inconclusive("Could not find a SyncGroup to try and reproduce");
        }

        [Test]
        public void GetSyncProfile() {
            var result = Proxy.TryCall<CServiceResponse<List<CSyncedGameInstance>>>(delegate(CClientServiceClient svc) {
                return svc.GetSyncProfile();
            });

            if (result != null) {
                Assert.AreEqual(EServiceResponseStatus.Successful, result.Status);
            }
            else Assert.IsNotNull(result);
        }

        [Test(Description = "Have not figured out how to really test this one yet.")]
        public void JoinSyncGroup() {
            Assert.Pass();
            //var computerName = Guid.NewGuid().ToString().Substring(0, 10);
            //var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc) {
            //    return svc.JoinSyncGroup(_newInstanceId, computerName, _instanceGuid, _instanceLabel);
            //});

            //if (result != null) {
            //    Assert.AreEqual(EServiceResponseStatus.Successful, result.Status);
            //}
            //else Assert.IsNotNull(result);
        }

        [Test(Description = "Try to join a group you are already in.")]
        public void JoinSyncGroupExisting() {
            var getSyncGroupResult = Proxy.TryCall<CServiceResponse<List<CSyncedGameInstance>>>(delegate(CClientServiceClient svc) {
                return svc.GetSyncProfile();
            });

            if (getSyncGroupResult != null) {
                if (getSyncGroupResult.Value.Count <= 0) {
                    Assert.Inconclusive("Could not find an existing SyncGroup to join");
                    return;
                }

                var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc) {
                    return svc.JoinSyncGroup(getSyncGroupResult.Value[0].InstanceID, _computerName, _instanceGuid, _instanceLabel);
                });

                if (result != null) {
                    Assert.AreEqual(EServiceResponseStatus.JoinSyncGroup_AlreadyInGroup, result.Status);
                }
                else Assert.IsNotNull(result);
            }
            else Assert.Inconclusive("Could not find an existing SyncGroup to join");
        }

        [Test(Description = "Try to join a group that does not exist.")]
        public void JoinSyncGroupBadGroupId() {
            var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc) {
                return svc.JoinSyncGroup(-1, _computerName, _instanceGuid, _instanceLabel);
            });

            if (result != null) {
                Assert.AreEqual(EServiceResponseStatus.JoinSyncGroup_GroupNotFound, result.Status);
            }
            else Assert.IsNotNull(result);
        }

        [Test]
        public void LeaveSyncGroup() {
            //var getSyncGroupResult = Proxy.TryCall<CServiceResponse<List<CSyncedGameInstance>>>(delegate(CClientServiceClient svc) {
            //    return svc.GetSyncProfile();
            //});

            //if (getSyncGroupResult != null) {
            //    foreach( var sync in getSyncGroupResult.Value){
            //    var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc) {
            //        return svc.LeaveSyncGroup(sync.InstanceID, sync.Computers[0].ComputerID, _instanceGuid);
            //    });

            //    if (result != null) {
            //        Assert.AreEqual(EServiceResponseStatus.Successful, result.Status);
            //    }
            //    else Assert.IsNotNull(result);    
            //    }
            //}
            //else Assert.Inconclusive("Could not find a SyncGroup to leave");
        }

        [Test(Description = "Attempt to leave a sync group with a bad computer id.")]
        public void LeaveSyncGroupBadCompId() {
            var getSyncGroupResult = Proxy.TryCall<CServiceResponse<List<CSyncedGameInstance>>>(delegate(CClientServiceClient svc) {
                return svc.GetSyncProfile();
            });

            if (getSyncGroupResult != null) {
                foreach (var sync in getSyncGroupResult.Value) {
                    var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc) {
                        return svc.LeaveSyncGroup(sync.InstanceID, -1, _instanceGuid);
                    });

                    if (result != null) {
                        Assert.AreEqual(EServiceResponseStatus.LeaveSyncGroup_ComputerNotFound, result.Status);
                    }
                    else Assert.IsNotNull(result);
                }
            }
            else Assert.Inconclusive("Could not find a SyncGroup to leave");
        }

        [Test(Description = "Attempt to leave an invalid sync group.")]
        public void LeaveInvalidSyncGroup() {
            var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc) {
                return svc.LeaveSyncGroup(-1, -1, _instanceGuid);
            });

            if (result != null) {
                Assert.AreEqual(EServiceResponseStatus.LeaveSyncGroup_GroupNotFound, result.Status);
            }
            else Assert.IsNotNull(result);
        }

        [Test]
        public void SaveSyncSnapshot() {
            var groupId = GetInstanceID();
            if (groupId == 0) {
                Assert.Inconclusive("Could not pull a group.");
                return;
            }

            var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc) {
                return svc.SaveSyncSnapshot(groupId, SyncedAddons);
            });

            if (result != null) {
                Assert.AreEqual(EServiceResponseStatus.Successful, result.Status);
            }
            else Assert.IsNotNull(result);
        }

        [Test]
        public void SaveSyncSnapshotBadGroupId() {
            var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc) {
                return svc.SaveSyncSnapshot(-1, SyncedAddons);
            });

            if (result != null) {
                Assert.AreEqual(EServiceResponseStatus.SaveSyncSnapshot_GroupNotFound, result.Status);
            }
            else Assert.IsNotNull(result);
        }

        [Test]
        public void SaveSyncTransactions() {
            var groupId = GetInstanceID();
            if (groupId == 0) {
                Assert.Inconclusive("Could not pull a group.");
                return;
            }

            var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc) {
                return svc.SaveSyncTransactions(groupId, SyncTransactions);
            });

            if (result != null) {
                Assert.AreEqual(EServiceResponseStatus.Successful, result.Status);
            }
            else Assert.IsNotNull(result);
        }

        [Test]
        public void SaveSyncTransactionsBadGroupId() {
            var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc) {
                return svc.SaveSyncTransactions(-1, SyncTransactions);
            });

            if (result != null) {
                Assert.AreEqual(EServiceResponseStatus.SaveSyncTransactions_GroupNotFound, result.Status);
            }
            else Assert.IsNotNull(result);
        }

        #region Random Methods
        private int GetInstanceID() {
            using (var conn = new SqlConnection(ClientServiceConnectionString)) {
                var cmd = new SqlCommand("SELECT InstanceID FROM SyncedGameInstance WHERE InstanceName = @name", conn);
                cmd.Parameters.Add("name", System.Data.SqlDbType.VarChar).Value = _instanceName;

                conn.Open();
                var value = cmd.ExecuteScalar();
                if (value != DBNull.Value && value != null)
                    return (int)value;
                else return 0;
            }
        }

        private void LeaveAllSyncGroups() {
            var getSyncGroupResult = Proxy.TryCall<CServiceResponse<List<CSyncedGameInstance>>>(delegate(CClientServiceClient svc) {
                return svc.GetSyncProfile();
            });

            if (getSyncGroupResult != null) {
                foreach (var sync in getSyncGroupResult.Value) {
                    var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc) {
                        return svc.LeaveSyncGroup(sync.InstanceID, sync.Computers[0].ComputerID, _instanceGuid);
                    });
                }
            }
        }
        #endregion
    }
}
