﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ServiceUnitTests.Attributes;
using ServiceUnitTests.TestFixtures;
using Curse.CurseClient.Common;
using NUnit.Framework;
using System.Configuration;
using Curse.ClientService.Models;
using Curse.CurseClient.Common.ClientService;
using System.Data.SqlClient;
using System.IO;
using System.Net;

namespace ServiceUnitTests.UnitTests.ClientService
{
    [ClientUnitTests]
    class SavedGameSyncTests : ClientServiceTestFixture
    {
        //static string _premiumUserName = "automationAdmin";
        //static string _premiumPassword = "automation";
        //CLoginResult _loginResult;
        static int _userId = 8107923;

        static int _gameId = 449;
        static string _fileName = @"testSkyrim.zip";
        static string _filePath = @"C:\temp\testSkyrim.zip";
        static string _computerName = Environment.MachineName;
        //static int _maxSavedGamesFree;
        //static int _maxRevisionsFree;
        //static int _maxSavedGamesPremium;
        //static int _maxRevisionsPremium;

        //[SetUp]
        //public new void Init()
        //{
        //    // Setup the service for a login
        //    Proxy.Username = _premiumUserName;
        //    Proxy.PlainTextPassword = _premiumPassword;

        //    // Do the actual login
        //    _loginResult = Proxy.LoginUser();

        //    // Set Revision Limits
        //    _maxSavedGamesFree = Int32.Parse(ConfigurationManager.AppSettings["MaxSavedGamesFree"]);
        //    _maxRevisionsFree = Int32.Parse(ConfigurationManager.AppSettings["MaxRevisionsFree"]);
        //    _maxSavedGamesPremium = Int32.Parse(ConfigurationManager.AppSettings["MaxSavedGamesPremium"]);
        //    _maxRevisionsPremium = Int32.Parse(ConfigurationManager.AppSettings["MaxRevisionsPremium"]);
        //}

        [TearDown] // We don't want this to happen
        public new void ResetConnection() { }

        [Test]
        public void GetSavedGames()
        {
            var result = Proxy.TryCall<CServiceResponse<List<CSavedGame>>>(delegate(CClientServiceClient svc)
            {
                return svc.GetSavedGames();
            });

            if (result.Status == EServiceResponseStatus.Successful)
            {
                var savedGames = result.Value;

                using (var conn = new SqlConnection(ClientServiceConnectionString))
                {
                    var cmd = new SqlCommand("SELECT * FROM SavedGame WHERE UserID = @UserID", conn);
                    cmd.Parameters.Add("UserID", System.Data.SqlDbType.Int).Value = _userId;

                    conn.Open();
                    using (var reader = cmd.ExecuteReader())
                    {
                        while (reader.Read())
                        {
                            var id = (int)reader["ID"];

                            Assert.IsNotNull(savedGames.FirstOrDefault(p => p.ID == id));
                        }
                    }
                }
            }
            else Assert.AreEqual(EServiceResponseStatus.Successful, result.Status);
        }

        [Test]
        public void DeleteSavedGame()
        {
            var savedGameResult = Proxy.TryCall<CServiceResponse<List<CSavedGame>>>(delegate(CClientServiceClient svc)
            {
                return svc.GetSavedGames();
            });

            if (savedGameResult.Status == EServiceResponseStatus.Successful)
            {
                var savedGames = savedGameResult.Value;
                if (savedGames.Count <= 0)
                {
                    savedGames = CreateSavedGameSync();
                }

                var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc)
                {
                    return svc.DeleteSavedGame(savedGames[0].ID);
                });

                if (result.Status == EServiceResponseStatus.Successful)
                {
                    using (var conn = new SqlConnection(ClientServiceConnectionString))
                    {
                        var cmd = new SqlCommand("SELECT count(*) FROM SavedGame WHERE ID = @ID", conn);
                        cmd.Parameters.Add("ID", System.Data.SqlDbType.Int).Value = savedGames[0].ID;

                        conn.Open();
                        var count = (int)cmd.ExecuteScalar();
                        Assert.AreEqual(0, count);
                    }
                }
                else Assert.AreEqual(EServiceResponseStatus.Successful, result.Status);
            }
            else Assert.Inconclusive("GetSavedGames call failed.");
        }

        [Test]
        public void DeleteSavedGameRevision()
        {
            var savedGameResult = Proxy.TryCall<CServiceResponse<List<CSavedGame>>>(delegate(CClientServiceClient svc)
            {
                return svc.GetSavedGames();
            });

            if (savedGameResult.Status == EServiceResponseStatus.Successful)
            {
                var savedGames = savedGameResult.Value;
                if (savedGames.Count <= 0)
                {
                    savedGames = CreateSavedGameSync();
                    Assert.AreNotEqual(0, savedGames.Count);
                }
                else if (savedGames[0].SavedGameRevisions.Count <= 0)
                {
                    Assert.Inconclusive("No revisions to delete.");
                }

                var revision = savedGames[0].SavedGameRevisions[0];

                var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc)
                {
                    return svc.DeleteSavedGameRevision(revision.SavedGameID, revision.ID);
                });

                if (result.Status == EServiceResponseStatus.Successful)
                {
                    using (var conn = new SqlConnection(ClientServiceConnectionString))
                    {
                        var cmd = new SqlCommand("SELECT count(*) FROM SavedGameRevision WHERE ID = @ID", conn);
                        cmd.Parameters.Add("ID", System.Data.SqlDbType.Int).Value = revision.ID;

                        conn.Open();
                        var count = (int)cmd.ExecuteScalar();
                        Assert.AreEqual(0, count);
                    }
                }
                else Assert.AreEqual(EServiceResponseStatus.Successful, result.Status);
            }
            else Assert.Inconclusive("GetSavedGames call failed.");
        }

        [Test]
        public void SetSavedGameStatus()
        {
            var savedGameResult = Proxy.TryCall<CServiceResponse<List<CSavedGame>>>(delegate(CClientServiceClient svc)
            {
                return svc.GetSavedGames();
            });

            if (savedGameResult.Status == EServiceResponseStatus.Successful)
            {
                var savedGames = savedGameResult.Value;
                if (savedGames.Count <= 0)
                {
                    Assert.Inconclusive("No saved games to delete.");
                }

                var status = ESavedGameStatus.Private;
                if (savedGames[0].Status == status)
                {
                    status = ESavedGameStatus.Public;
                }

                var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc)
                {
                    return svc.SetSavedGameStatus(savedGames[0].ID, status);
                });

                if (result.Status == EServiceResponseStatus.Successful)
                {
                    using (var conn = new SqlConnection(ClientServiceConnectionString))
                    {
                        var cmd = new SqlCommand("SELECT Status FROM SavedGame WHERE ID = @ID", conn);
                        cmd.Parameters.Add("ID", System.Data.SqlDbType.Int).Value = savedGames[0].ID;

                        conn.Open();
                        var newStatus = (ESavedGameStatus)(byte)cmd.ExecuteScalar();
                        Assert.AreEqual(status, newStatus);
                    }
                }
                else Assert.AreEqual(EServiceResponseStatus.Successful, result.Status);
            }
            else Assert.Inconclusive("GetSavedGames call failed.");
        }

        [Test]
        public void SetSavedGameName()
        {
            var savedGameResult = Proxy.TryCall<CServiceResponse<List<CSavedGame>>>(delegate(CClientServiceClient svc)
            {
                return svc.GetSavedGames();
            });

            if (savedGameResult.Status == EServiceResponseStatus.Successful)
            {
                var savedGames = savedGameResult.Value;
                if (savedGames.Count <= 0)
                {
                    Assert.Inconclusive("No saved games to delete.");
                }

                var name = Guid.NewGuid().ToString();
                var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc)
                {
                    return svc.SetSavedGameName(savedGames[0].ID, name);
                });

                if (result.Status == EServiceResponseStatus.Successful)
                {
                    using (var conn = new SqlConnection(ClientServiceConnectionString))
                    {
                        var cmd = new SqlCommand("SELECT Name FROM SavedGame WHERE ID = @ID", conn);
                        cmd.Parameters.Add("ID", System.Data.SqlDbType.Int).Value = savedGames[0].ID;

                        conn.Open();
                        var newName = (string)cmd.ExecuteScalar();
                        Assert.AreEqual(name, newName);
                    }
                }
                else Assert.AreEqual(EServiceResponseStatus.Successful, result.Status);
            }
            else Assert.Inconclusive("GetSavedGames call failed.");
        }

        [Test]
        public void SetSavedGameDescription()
        {
            var savedGameResult = Proxy.TryCall<CServiceResponse<List<CSavedGame>>>(delegate(CClientServiceClient svc)
            {
                return svc.GetSavedGames();
            });

            if (savedGameResult.Status == EServiceResponseStatus.Successful)
            {
                var savedGames = savedGameResult.Value;
                if (savedGames.Count <= 0)
                {
                    Assert.Inconclusive("No saved games to delete.");
                }

                var description = Guid.NewGuid().ToString();
                var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc)
                {
                    return svc.SetSavedGameDescription(savedGames[0].ID, description);
                });

                if (result.Status == EServiceResponseStatus.Successful)
                {
                    using (var conn = new SqlConnection(ClientServiceConnectionString))
                    {
                        var cmd = new SqlCommand("SELECT Description FROM SavedGame WHERE ID = @ID", conn);
                        cmd.Parameters.Add("ID", System.Data.SqlDbType.Int).Value = savedGames[0].ID;

                        conn.Open();
                        var newDesc = (string)cmd.ExecuteScalar();
                        Assert.AreEqual(description, newDesc);
                    }
                }
                else Assert.AreEqual(EServiceResponseStatus.Successful, result.Status);
            }
            else Assert.Inconclusive("GetSavedGames call failed.");
        }

        [Test]
        public void SyncSavedGame()
        {
            using (var stream = new FileStream(_filePath, FileMode.Open))
            {
                using (var client = CServiceProxy.GetBackupServiceClient())
                {
                    client.SyncSavedGame(_computerName, DateTime.UtcNow, _fileName, 0, _gameId, stream);
                }
            }
        }

        [Test]
        public void AddRevision()
        {
            using (var stream = new FileStream(_filePath, FileMode.Open))
            {
                using (var client = CServiceProxy.GetBackupServiceClient())
                {
                    client.AddRevision(_computerName, DateTime.UtcNow, _fileName, 0, _gameId, stream);
                }
            }
        }

        [Test]
        public void DownloadRevision()
        {
            var savedGameResult = Proxy.TryCall<CServiceResponse<List<CSavedGame>>>(delegate(CClientServiceClient svc)
            {
                return svc.GetSavedGames();
            });

            if (savedGameResult.Status == EServiceResponseStatus.Successful)
            {
                var savedGames = savedGameResult.Value;
                if (savedGames.Count <= 0)
                {
                    savedGames = CreateSavedGameSync();
                }

                foreach (var savedGame in savedGames)
                {
                    var revision = savedGame.SavedGameRevisions.FirstOrDefault(p => p.ID == savedGame.DefaultRevisionID);
                    Assert.IsNotNull(revision, "DefaultRevisionID did not point to a valid revision");
                    Assert.IsNotNull(revision.DownloadUrl, "Revision DownloadUrl was null.");

                    var request = (HttpWebRequest)WebRequest.Create(revision.DownloadUrl);
                    var response = request.GetResponse();
                    var contentType = response.Headers["Content-Type"];
                    Assert.AreEqual(@"application/x-zip-compressed", contentType);
                }
            }
            else Assert.Inconclusive("GetSavedGames call failed.");
        }

        [Test]
        public void SetSavedGameRevision()
        {
        }

        [Test]
        public void GetSavedGameConstraintsPremium()
        {
            //var result = Proxy.TryCall<CServiceResponse<CSavedGameConstraints>>(delegate(CClientServiceClient svc)
            //{
            //    return svc.GetSavedGameConstraints();
            //});
            //Assert.IsNotNull(result.Value);

            //Assert.AreEqual(_maxSavedGamesPremium, result.Value.MaxSavedGameCount);
            //Assert.AreEqual(_maxRevisionsPremium, result.Value.MaxRevionCount);
        }

        [Test]
        public void UploadAvailableForUser()
        {
            var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc)
            {
                return svc.UploadAvailableForUser();
            });
            
            Assert.AreEqual(EServiceResponseStatus.Successful, result.Status);
        }

        [Test]
        public void SetSavedGameRestrictionLevelDisabled()
        {
            var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc)
            {
                return svc.SetSavedGameRestrictionLevel(ESavedGameRestrictionLevel.Disabled);
            });

            Assert.AreEqual(EServiceResponseStatus.Successful, result.Status);
        }

        [Test]
        public void SetSavedGameRestrictionLevelPremium()
        {
            var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc)
            {
                return svc.SetSavedGameRestrictionLevel(ESavedGameRestrictionLevel.PremiumOnly);
            });

            Assert.AreEqual(EServiceResponseStatus.Successful, result.Status);
        }

        [Test]
        public void SetSavedGameRestrictionLevelAllUsers()
        {
            var result = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc)
            {
                return svc.SetSavedGameRestrictionLevel(ESavedGameRestrictionLevel.AllUsers);
            });

            Assert.AreEqual(EServiceResponseStatus.Successful, result.Status);
        }

        [Test]
        public void GetSavedGameRestrictionLevel()
        {
            var restrictionLevel = (ESavedGameRestrictionLevel)new Random(DateTime.Now.Millisecond).Next(1, 3);

            var setResult = Proxy.TryCall<CServiceResponse>(delegate(CClientServiceClient svc)
            {
                return svc.SetSavedGameRestrictionLevel(restrictionLevel);
            });

            if (setResult.Status != EServiceResponseStatus.Successful)
            {
                Assert.Inconclusive("Could not set the restriction level.");
            }

            var result = Proxy.TryCall<CServiceResponse<ESavedGameRestrictionLevel>>(delegate(CClientServiceClient svc)
            {
                return svc.GetSavedGameRestrictionLevel();
            });
            Assert.IsNotNull(result.Value);

            Assert.AreEqual(restrictionLevel, result.Value);
        }

        private List<CSavedGame> CreateSavedGameSync()
        {
            var savedGames = new List<CSavedGame>();
            using (var stream = new FileStream(_filePath, FileMode.Open))
            {
                using (var client = CServiceProxy.GetBackupServiceClient())
                {
                    client.SyncSavedGame(_computerName, DateTime.UtcNow, _fileName, 0, _gameId, stream);
                }
            }

            var result = Proxy.TryCall<CServiceResponse<List<CSavedGame>>>(delegate(CClientServiceClient svc)
            {
                return svc.GetSavedGames();
            });
            if (result.Status == EServiceResponseStatus.Successful)
            {
                savedGames = result.Value;
            }

            return savedGames;
        }
    }
}
