﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ServiceUnitTests.Attributes;
using ServiceUnitTests.TestFixtures;
using NUnit.Framework;
using System.ServiceModel;
using Curse.CurseClient.Common.ClientService;
using Curse.ClientService.Models;
using Curse.CurseClient.Common;
using System.Diagnostics;
using System.IO;
using System.Threading;

namespace ServiceUnitTests.UnitTests.ClientService {
    [ClientUnitTests]
    class ServiceTests : ClientServiceTestFixture {
        [Test]
        [ExpectedException(typeof(FaultException))]
        public void UnauthorizedAccess() {
            Proxy.Logout();
            Proxy.Username = string.Empty;
            Proxy.PlainTextPassword = string.Empty;

            var result = Proxy.TryCall<CSession>(delegate(CClientServiceClient svc) {
                return svc.GetCurrentSession();
            });
        }

        [Test]
        public void IsConnected() {
            Assert.AreEqual(true, Proxy.IsConnected);
        }

        [Test]
        public void UserID() {
            Assert.IsNotNull(Proxy.UserID);
        }

        [Test]
        public void IsPremium() {
            Assert.IsNotNull(Proxy.IsPremium);
        }

        [Test]
        public void IsSubscribed() {
            Assert.IsNotNull(Proxy.IsSubscribed);
        }

        [Test]
        public void SessionID() {
            Assert.IsNotNull(Proxy.SessionID);
        }

        [Test]
        public void GetCurrentSession() {
            var result = Proxy.TryCall<CSession>(delegate(CClientServiceClient svc) {
                return svc.GetCurrentSession();
            });

            if (result != null) {
                Assert.AreEqual(Proxy.SessionID, result.SessionID);
            }
            else Assert.IsNotNull(result);
        }

        [Test]
        public void SaveHardwareProfile() {
            string dxDiagXml = null;
            try {
                dxDiagXml = GetDxDiagXml();
            }
            catch (Exception) {
                Assert.Inconclusive("Could not pull the dxDiagXml.");
            }

            if (dxDiagXml == null) Assert.Inconclusive("dxDiagXml was null.");
            var report = new CHardwareProfile();
            if (report.SetFromSystemData(dxDiagXml)) {
                var result = Proxy.TryCall<bool>(delegate(CClientServiceClient svc) {
                    return svc.SaveHardwareProfile(new CHardwareProfile());
                });

                Assert.AreEqual(true, result);
            }
            else Assert.Inconclusive("Could not create the hardware profile object.");
        }

        [Test]
        public void SaveUsageProfile() {
            var addonIds = new List<int>();
            foreach (var addon in Addons) {
                addonIds.Add(addon.Key);
            }

            CUsageProfile usageProfile = new CUsageProfile() {
                ClientVersion = CUtility.ApplicationVersion.ToString(),
                OperatingSystemVersion = CSystemInformationUtility.GetOperatingSystemName(),
                OperatingSystemPlatform = "Windows",
                InstalledAddons = addonIds.ToArray(),
                MainWindowHeight = 100,
                MainWindowWidth = 100,
                ViewShowSidebar = false,
                ViewShowGameHeader = false,
                ViewShowToolbarLabel = false,
                DefaultGameID = 1,
                RoundedCorners = false,
                SoftwareRendering = false,
                DotNetVersion = 4.5F
            };

            var metric = new Curse.ClientService.Models.CGameMetric
            {
                GameId = 1,
                TimesSelected = 20,
                InfoClickWebsite = 1,
                InfoClickChangeLog = 2,
                InfoClickDescription = 3,
                InfoClickDonate = 4,
                PlayButtonClick = 5,
                LocalSavesCount = 6,
                InstanceCount = 1,
                ColumnCount = 4
            };

            metric.TabsUsed.AddRange(new string[] {"My Addons", "Get More Addons"});

            usageProfile.GameMetrics.Add(metric);

            var result = Proxy.TryCall<bool>(delegate(CClientServiceClient svc) {
                return svc.SaveUsageProfile(usageProfile);
            });

            Assert.AreEqual(true, result);
        }
        


        #region Support Methods
        private static string GetDxDiagXml() {
            string filename = Path.Combine(CUtility.TempPath, CUtility.UniqueNumber + ".xml");
            Process p = new Process();
            p.StartInfo.FileName = "dxdiag.exe";
            p.StartInfo.WindowStyle = ProcessWindowStyle.Hidden;
            p.StartInfo.Arguments = "/x " + filename;
            p.StartInfo.WorkingDirectory = Environment.SystemDirectory;
            p.Start();

            int counter = 0;
            while (!File.Exists(filename) && counter < 18) // Give it 90 seconds to generate the report:
            {
                Thread.Sleep(5000); // Wait 5 seconds
                ++counter;
            }
            Thread.Sleep(5000);
            if (!File.Exists(filename)) {
                return null;
            }

            string fileContents = null;
            using (StreamReader reader = new StreamReader(filename)) {
                fileContents = reader.ReadToEnd();
            }
            File.Delete(filename);
            return fileContents;
        }
        #endregion
    }
}
