﻿using System;
using System.IO;
using System.Configuration;
using System.Net;
using Curse;
using System.Threading;

namespace VoiceSubscriptionMiner
{
	class Program
	{
		static object _startLock = new object();
		private static Mutex _applicationMutex = new Mutex(false, "Curse.Xenon.VoiceSubscriptionManager");

		static void Main(string[] args)
		{
			var immediate = false;
			if (args.Length > 0)
			{
				switch (args[0])
				{
					case "-i": // Do not wait
						immediate = true;
						break;
					case "-r": // Reconcile
						VoiceInvoiceManager.Instance.Initialize(VoiceInvoiceManagerOption.Reconcile);
						return;
					case "-c": // Cancel
						VoiceInvoiceManager.Instance.Initialize(VoiceInvoiceManagerOption.Cancel);
						return;
				}
			}

			lock (_startLock)
			{
				//Setup Logging
				Logger.SetLogLevel = ELogLevel.Debug;
				var logPath = ConfigurationManager.AppSettings["LogPath"];
				if (!Directory.Exists(logPath))
				{
					Directory.CreateDirectory(logPath);
				}
				Logger.SetLogPath = logPath;
				Logger.Log("Voice Subscription Manager Started...", ELogLevel.Info, string.Join("|", args));

				// Need this to make the serice calls work
				ServicePointManager.Expect100Continue = true;
				ServicePointManager.SecurityProtocol = SecurityProtocolType.Ssl3;

				if (!_applicationMutex.WaitOne(TimeSpan.FromSeconds(5), false))
				{
					Logger.Log("Only one instance of the manager can be running at a time.", ELogLevel.Error);
					return;
				}

				try
				{
					new Thread(() =>
						{
							VoiceSubscriptionManager.Instance.Start(immediate);
						}).Start();

					bool keepRunning = true;
					while (keepRunning)
					{
						ConsoleKeyInfo keyInfo = Console.ReadKey(false);
						if (keyInfo.Key == ConsoleKey.Escape)
						{
							Logger.Log("Voice Subscription Manager Stopping...", ELogLevel.Info);
							keepRunning = false;
						}
					}
					VoiceSubscriptionManager.Instance.Stop();
				}
				finally
				{
					_applicationMutex.ReleaseMutex();
				}
			}
		}//main
	}
}
