﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Configuration;
using VoiceSubscriptionMiner.Models;

namespace VoiceSubscriptionMiner
{
	enum VoiceInvoiceManagerOption
	{
		Reconcile,
		Cancel
	}

	class VoiceInvoiceManager
	{
		string _invoiceFileLocation;

		static VoiceInvoiceManager _instance = new VoiceInvoiceManager();
		public static VoiceInvoiceManager Instance { get { return _instance; } }

		public VoiceInvoiceManager() { }
		public void Initialize(VoiceInvoiceManagerOption option)
		{
			_invoiceFileLocation = ConfigurationManager.AppSettings["InvoicePath"];
			switch (option)
			{
				case VoiceInvoiceManagerOption.Reconcile:
					{
						var files = Directory.GetFiles(_invoiceFileLocation, "*Invoice.txt");
						foreach (string file in files)
						{
							ParseInvoiceFile(file);
						}
					} break;
				case VoiceInvoiceManagerOption.Cancel:
					{
						var files = Directory.GetFiles(_invoiceFileLocation, "*Cancel.txt");
						foreach (string file in files)
						{
							CancelVoiceSubscriptions(file);
						}
					} break;
			}
		}

		void CancelVoiceSubscriptions(string filename)
		{
			using (var sr = new StreamReader(filename))
			{
				var serviceIds = sr.ReadToEnd().Replace("\r", "").Split('\n');
				foreach (var serviceId in serviceIds)
				{
					VoiceSubscriptionManager.CancelVoiceSub(uint.Parse(serviceId));
				}
			}
		}

		void ParseInvoiceFile(string filename)
		{
			var voiceSubs = VoiceSubInvoiceData.ParseInvoiceFile(filename);
			VoiceSubInvoiceData.GenerateOverview(voiceSubs, filename.Replace(".txt", "_OverviewReport.txt"));
			VoiceSubInvoiceData.GenerateServiceWithoutSubscriptionReport(voiceSubs, filename.Replace(".txt", "_ServiceWithoutSubReport.csv"));
			VoiceSubInvoiceData.GenerateChannelsByDayOverview(voiceSubs, filename.Replace(".txt", "_ChannelByDayOverview.csv"));

			//VoiceSubInvoiceData.GenerateMissingSubscriptionReport(voiceSubs, filename.Replace(".txt", "_MissingSubReport.csv"));
			//VoiceSubInvoiceData.GenerateChannelsByDayReport(voiceSubs, filename.Replace(".txt", "_ChannelByDayReport.csv"));
			//VoiceSubInvoiceData.GenerateValidationReport(voiceSubs, filename.Replace(".txt", "_ValidationReport.csv"));
			//VoiceSubInvoiceData.GenerateTotalChannelReport(voiceSubs, filename.Replace(".txt", "_TotalChannelReport.csv"));
		}
	}
}
