﻿using Curse;
using Curse.WAR;
using System;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;

namespace WARDataService
{
    public static partial class DBBattlefieldStatus
    {

        private static Dictionary<CustomKey, DateTime> sBattlefieldExpirations =
                    new Dictionary<CustomKey, DateTime>(new CustomKey.CustomKeyComparer());

        private static DataTable sTableSchema = null;

        private static String sBattlefieldQuery = "update battlefield " +
                                                "set order_control={0}" +
                                                ",destruction_control={1}" +
                                                ",controller={2}" +
                                                ",destruction_buff_xp=COALESCE({3},{3},destruction_buff_xp)" +
                                                ",destruction_buff_renown=COALESCE({4},{4},destruction_buff_renown)" +
                                                ",order_buff_xp=COALESCE({5},{5},order_buff_xp)" +
                                                ",order_buff_renown=COALESCE({6},{6},order_buff_renown)" +
                                                ",updated=GetUTCDate()" +
                                                " where id={9};" +
                                                " IF @@ROWCOUNT = 0" +
                                                " INSERT INTO battlefield(order_control,destruction_control,controller" +
                                                ",destruction_buff_xp,destruction_buff_renown,order_buff_xp,order_buff_renown,updated,server_id,zone_id,id)" +
                                                " values({0},{1},{2},IsNull({3},0),IsNull({4},0),IsNull({5},0),IsNull({6},0),GetUTCDate(),{7},{8},{9});";
                                                
                                                


        public static void Initialize()
        {
            DB.LoadSchema(ref sTableSchema, "battlefield_point");
        }

        public static void Save(Update pUpdate, SqlConnection pConn)
        {
            
            if (pUpdate.BattlefieldStatus.Count == 0)
            {
                return;
            }

            Int32 serverId = DBServers.GetServerId(pUpdate.ServerName);
            if (serverId == 0)
            {
                return;
            }
            Int32 sideId = WarUtility.GetSideFromRace(pUpdate.Players[0].Race);

         
            DataRow dr = null;
            DataTable dtInsert = sTableSchema.Clone();
            dtInsert.BeginLoadData();

            CustomKey key = null;
            String deleteIds = "";
            StringBuilder sql = new StringBuilder(1000);
            
            Int32 battlefieldId = 0;

            foreach (BattlefieldStatus battlefield in pUpdate.BattlefieldStatus)
            {
                if (battlefield.Points.Count == 0)
                {
                    continue;
                }

                key = new CustomKey(battlefield.ZoneId, serverId, sideId);
                // Expire battlefield status every 5 mins.
                if(!DB.IsEntityExpired(sBattlefieldExpirations, key, 60 * 5, pUpdate.IsTrustedUser))
                {
                    continue;
                }
                battlefieldId = Math.Abs((battlefield.ZoneId.ToString() + "|" + serverId.ToString()).GetHashCode());

                String orderXp, orderRenown, destXp, destRenown;
                if(sideId == 1)
                {
                    orderXp = battlefield.XpBuff.ToString();
                    orderRenown = battlefield.RenownBuff.ToString();
                    destXp= "null";
                    destRenown= "null";                    
                }
                else
                {
                    destXp = battlefield.XpBuff.ToString();
                    destRenown = battlefield.RenownBuff.ToString();
                    orderXp= "null";
                    orderRenown= "null";                    
                }

                sql.AppendFormat(sBattlefieldQuery, 
                                    battlefield.OrderControl,
                                    battlefield.DestructionControl,
                                    battlefield.Controller,
                                    destXp,
                                    destRenown,
                                    orderXp,
                                    orderRenown,
                                    serverId,
                                    battlefield.ZoneId,
                                    battlefieldId);

                deleteIds = deleteIds + "," + battlefield.ZoneId;

                foreach (BattlefieldStatusPoint point in battlefield.Points)
                {
                    dr = dtInsert.NewRow();
                    dr["battlefield_id"] = battlefieldId;
                    dr["server_id"] = serverId;
                    dr["zone_id"] = battlefield.ZoneId;
                    dr["name"] = point.Name;
                    dr["icon"] = point.Icon;
                    dtInsert.Rows.Add(dr);
                }
            }

            if (deleteIds.Length > 0)
            {

                SqlCommand cmd = pConn.CreateCommand();
                cmd.CommandText = "delete from battlefield_point where server_id = " + serverId + " and zone_id in(" + deleteIds.Substring(1) + ");" +
                        sql.ToString();

                cmd.ExecuteNonQuery();

                using (SqlBulkCopy bulkInsert = new SqlBulkCopy(pConn,
                                                SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                null))
                {
                    bulkInsert.BatchSize = 50;
                    bulkInsert.DestinationTableName = "battlefield_point";
                    bulkInsert.WriteToServer(dtInsert);
                }
                

            }
           

        }

    }
}
