﻿using Curse;
using Curse.WAR;
using System;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
namespace WARDataService
{

    public static partial class DBGameObjects
    {
        

        private static Dictionary<CustomKey, Int32> sGameObjectNameToId = new Dictionary<CustomKey, Int32>(new CustomKey.CustomKeyComparer());                

        private static Dictionary<CustomKey, DateTime> sHistory =
            new Dictionary<CustomKey, DateTime>(new CustomKey.CustomKeyComparer());

        private static Dictionary<CustomKey, Confirmation> sGameObjectConfirmations =
            new Dictionary<CustomKey, Confirmation>(new CustomKey.CustomKeyComparer());

        private static Dictionary<CustomKey, Confirmation> sGameObjectLocationConfirmations =
            new Dictionary<CustomKey, Confirmation>(new CustomKey.CustomKeyComparer());
        
        private static String sUpdateQuery = null;
        private static String sInsertQuery = null;

        private static String[] sUpdateIgnoredColumns = { "id", "posted", "posted_id", "version_id", "name" };
        private static String[] sIgnoreInsertColumns = {"id"};
        private static Dictionary<String, String> sUpdateCustomColumns = new Dictionary<string, string>();

        private static String sGameObjectLocationQueryFormat = "UPDATE gameobject_location SET " +
                                                        "total=total+1," +
                                                        "updated_id={0}," +
                                                        "updated=GETUTCDATE()" +
                                                        " WHERE gameobject_id={1} AND pos_x={4} AND pos_y={5}" +
                                                        " IF @@ROWCOUNT = 0 " +
                                                        "INSERT INTO gameobject_location(" +
                                                        "gameobject_id,version_id,zone_id," +
                                                        "pos_x,pos_y,total,updated_id,posted_id) VALUES(" +
                                                        "{1},{2},{3},{4},{5},1,{0},{0});";


        private static String sTempTableCreation = "SELECT TOP 0 * INTO #gameobject FROM gameobject;ALTER TABLE #gameobject DROP COLUMN id;ALTER TABLE #gameobject ADD id int;";
        
        private static DataTable sGameObjectUpdateSchema = null;
        private static DataTable sGameObjectInsertSchema = null;
        

        public static void Initialize()
        {            
            sHistory.Clear();
            sGameObjectNameToId.Clear();
                       
            foreach (String locale in DB.sLocalizations)
            {
                DB.PopulateNameToID(sGameObjectNameToId, "gameobject", locale);
            }
            DB.LoadSchema(ref sGameObjectUpdateSchema, "#gameobject", sTempTableCreation);
            DB.LoadSchema(ref sGameObjectInsertSchema, "gameobject");

            sInsertQuery = DB.GetInsertSQL(sGameObjectInsertSchema, sIgnoreInsertColumns);
            
            sUpdateQuery = "update gameobject set ";
            sUpdateQuery = sUpdateQuery + DB.GetUpdateSQL(sGameObjectUpdateSchema, sUpdateIgnoredColumns, sUpdateCustomColumns);
            sUpdateQuery = sUpdateQuery + " FROM gameobject,#gameobject tmp" +
                " WHERE gameobject.id=tmp.id;";

        }

        public static Int32 GetGameObjectId(String pNpcName, String pLocale)
        {
            return DB.GetIdFromName(sGameObjectNameToId, pNpcName, pLocale);
        }

        public static void AddGameObject(String pNpcName, String pLocale, Int32 pNpcId)
        {
            DB.AddNameFromId(sGameObjectNameToId, pLocale, pNpcName, pNpcId);  
        }


        private static void SetGameObjectLocationQuery(Int32 pGameObjectid, Update pUpdate, GameObject pGameObject, StringBuilder pBuilder)
        {
            // Locations
            foreach (EntityLocation location in pGameObject.Locations)
            {

                CustomKey key = new CustomKey(pGameObjectid,
                                            location.Zone,
                                            location.X,
                                            location.Y);

                if (!DB.IsEntityConfirmed(sGameObjectLocationConfirmations,
                                key,
                                Config.Instance.MinConfirmations,
                                pUpdate.UserId,
                                pUpdate.ClientVersion.Value,
                                pUpdate.IsTrustedUser))
                {
                    continue;
                }

                pBuilder.AppendFormat(sGameObjectLocationQueryFormat,
                    pUpdate.UserId,
                    pGameObjectid,
                    pUpdate.ClientVersion.Value,
                    location.Zone,
                    location.X,
                    location.Y);
            }

        }
        
        public static void Save(Update pUpdate, SqlConnection pConn)
        {

            if (pUpdate.GameObjects.Count == 0)
            {
                return;
            }

            StringBuilder sql = new StringBuilder();
            DataRow dr = null;
            DataTable dtInsert = sGameObjectInsertSchema.Clone();
            DataTable dtUpdate = sGameObjectUpdateSchema.Clone();

            dtInsert.BeginLoadData();
            dtUpdate.BeginLoadData();
            
            CustomKey key;
            String locale = pUpdate.Language.ToString();         
            SqlCommand cmd = pConn.CreateCommand();
            SqlBulkCopy bulkUpdate = new SqlBulkCopy(pConn,
                                                     SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                     null);

          
            bulkUpdate.BatchSize = 5000;                
            bulkUpdate.DestinationTableName = "#gameobject";


            bool isNewRow = false;
            Int32 gameObjectId = 0;            
            foreach (GameObject gameObject in pUpdate.GameObjects)
            {
                gameObjectId = GetGameObjectId(gameObject.Name.Value, locale);
                if (gameObjectId > 0)
                {
                    if (!DB.ReadyForDB(sHistory,
                                sGameObjectLocationConfirmations,
                                gameObjectId,
                                Config.Instance.NpcExpiration,
                                Config.Instance.MinConfirmations,
                                pUpdate.UserId,
                                pUpdate.ClientVersion.Value,
                                (ELocale)pUpdate.Language,
                                pUpdate.IsTrustedUser))
                    {
                        continue;
                    }
                    isNewRow = false;                        
                    dr = dtUpdate.NewRow();
                    dr["id"] = gameObjectId;
                }                                        
                else
                {
                    isNewRow = true;
                    dr = dtInsert.NewRow();
                }
                                                       
                dr["version_id"] = pUpdate.ClientVersion.Value;
                dr["name_" + locale] = gameObject.Name.Value;

                // Meta Data
                dr["updated_id"] = pUpdate.UserId;
                dr["posted_id"] = pUpdate.UserId;
                dr["posted"] = DateTime.UtcNow;
                dr["updated"] = DateTime.UtcNow;

                if (isNewRow)
                {
                    //dtInsert.Rows.Add(dr);
                    cmd.CommandText = DB.GetFilledInsertSQL(sInsertQuery, sGameObjectInsertSchema, dr, sIgnoreInsertColumns, locale);
                    gameObjectId = (Int32)cmd.ExecuteScalar();
                    AddGameObject(gameObject.Name.Value, locale, gameObjectId);                                               
                }
                else
                {
                    dtUpdate.Rows.Add(dr);
                }

                // Locations
                SetGameObjectLocationQuery (gameObjectId, pUpdate, gameObject, sql);
              
               
            }
            
            if (dtUpdate.Rows.Count > 0)
            {

                cmd.CommandText = sTempTableCreation;
                cmd.ExecuteNonQuery();                
                bulkUpdate.WriteToServer(dtUpdate);
                bulkUpdate.Close();

                cmd.CommandText = String.Format(sUpdateQuery, locale);
                cmd.ExecuteNonQuery();
                cmd.CommandText = "DROP TABLE #gameobject;";
                cmd.ExecuteNonQuery();
            }

            if (sql.Length > 0)
            {
                cmd.CommandText = sql.ToString();
                cmd.ExecuteNonQuery();
            }
            


        }
    }
    
}
