﻿using Curse;
using Curse.WAR;
using System;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.Data;
using System.Text;
namespace WARDataService
{
    public static partial class DBInfluence
    {        
        private static HashSet<CustomKey> sKnownInfluence =
            new HashSet<CustomKey>(new CustomKey.CustomKeyComparer());

        private static Dictionary<CustomKey, DateTime> sInfluenceExpirations =
            new Dictionary<CustomKey, DateTime>(new CustomKey.CustomKeyComparer());

        private static Dictionary<CustomKey, DateTime> sInfluenceRewardExpirations =
            new Dictionary<CustomKey, DateTime>(new CustomKey.CustomKeyComparer());

        private static Dictionary<CustomKey, Confirmation> sConfirmations =
            new Dictionary<CustomKey, Confirmation>(new CustomKey.CustomKeyComparer());

        private static String sUpdateQuery = null;

        private static String[] sUpdateIgnoredColumns = { "id", "version_id", "posted", "posted_id" };

        private static String sInfluenceRewardQueryFormat = "UPDATE influence_reward SET " +
                                    "careers=careers|{0}," +
                                    "updated_id={1}," +
                                    "updated=GETUTCDATE()," +
                                    "cost={2}" +
                                    " WHERE influence_id={3} AND item_id={4} and npc_id={5}" +
                                    " IF @@ROWCOUNT = 0 " +
                                    "INSERT INTO influence_reward(" +
                                    "influence_id,item_id,npc_id,careers,cost,level,updated_id) VALUES(" +
                                    "{3},{4},{5},{0},{2},{6},{1});";

        private static DataTable sInfluenceSchema = null;
        //private static DataTable sInfluenceRewardSchema = null;

        public static void Initialize()
        {
            sKnownInfluence.Clear();
            sInfluenceExpirations.Clear();

            foreach (Int32 version in Config.Instance.Versions)
            {                
                DB.PopulateId(sKnownInfluence, "influence", version);
            }
            DB.LoadSchema(ref sInfluenceSchema, "influence");
            //DB.LoadSchema(ref sInfluenceRewardSchema, "influence_reward");

            sUpdateQuery = "update influence set ";
            sUpdateQuery = sUpdateQuery + DB.GetUpdateSQL(sInfluenceSchema, sUpdateIgnoredColumns, new Dictionary<string, string>());
            sUpdateQuery = sUpdateQuery + " FROM influence,#influence tmp" +
                " WHERE influence.id=tmp.id;";

        }
        
        private static void SetInfluenceRewardQuery(Int32 pInfluenceId, Int32 pNpcId, Update pUpdate, Influence pInfluence, StringBuilder pBuilder)
        {
                /*
                 * 
                 * 1. Career Bit
                 * 2. User Id
                 * 3. Cost
                 * 4. Influence ID
                 * 5. Item Id
                 * 6. NPC Id
                 * 7. Level
                 * */
                
            //"influence_id,item_id,npc_id,careers,cost,level,updated_id,posted_id) VALUES(" +
              //                      "{3},{4},{5},{0},{2},{6},{1},{1});";

            Int32 careerBit = Utility.GetBitValue(pUpdate.Players[0].Career);

            foreach (InfluenceReward rewards in pInfluence.Rewards)
            {                              

                foreach(Int32 itemId in rewards.Items)
                {
                    pBuilder.AppendFormat(sInfluenceRewardQueryFormat,
                    careerBit,
                    pUpdate.UserId,
                    rewards.Cost,
                    pInfluenceId,
                    itemId,
                    pNpcId,
                    rewards.Phase);

                    // Update the item, so that it's source is reflagged:
                    pBuilder.AppendFormat("update item set updated=GetUTCDate() where id={0} and version_id={1};", itemId, pUpdate.ClientVersion.Value);

                }
                   
            }

        }

        public static void Save(Update pUpdate, SqlConnection pConn)
        {

            if (pUpdate.Influence.Count == 0)
            {
                return;
            }
            
            DataRow dr = null;
            DataTable dtInsert = sInfluenceSchema.Clone();
            //DataTable dtRewardInsert = sInfluenceRewardSchema.Clone();
            DataTable dtUpdate = sInfluenceSchema.Clone();

            dtInsert.BeginLoadData();
            dtUpdate.BeginLoadData();
            //dtRewardInsert.BeginLoadData();

            CustomKey key;
            String locale = pUpdate.Language.ToString();
                                
                
                bool isNewRow = false;
                foreach (Influence influence in pUpdate.Influence)
                {
                    if (!DB.ReadyForDB(sInfluenceExpirations,
                                    sConfirmations,
                                    influence.Id,
                                    Config.Instance.ItemExpiration,
                                    Config.Instance.MinConfirmations,
                                    pUpdate.UserId,
                                    pUpdate.ClientVersion.Value,
                                    (ELocale)pUpdate.Language,
                                    pUpdate.IsTrustedUser))
                    {
                        continue;
                    }

                    key = new CustomKey(pUpdate.ClientVersion.Value,
                                        influence.Id);

                    isNewRow = !sKnownInfluence.Contains(key);
                    if (isNewRow)
                    {
                        dr = dtInsert.NewRow();
                    }
                    else
                    {
                        dr = dtUpdate.NewRow();
                    }

                    dr["id"] = influence.Id;
                    dr["version_id"] = pUpdate.ClientVersion.Value;
                    dr["tome_section"] = influence.TomeSection;
                    dr["tome_entry"] = influence.TomeEntry;
                    dr["zone_id"] = influence.ZoneId;
                    dr["area_id"] = influence.AreaId;
                    Int32 influenceNpcId = DBNPCs.GetNpcId(influence.NPCName.Value, locale);
                    dr["npc_id"] = influenceNpcId;
                    dr["is_rvr"] = (influence.IsRvR == 1);
                    
                    // Meta Data
                    dr["updated_id"] = pUpdate.UserId;
                    dr["posted_id"] = pUpdate.UserId;
                    dr["posted"] = DateTime.UtcNow;
                    dr["updated"] = DateTime.UtcNow;

                    if (isNewRow)
                    {
                        dtInsert.Rows.Add(dr);
                        sKnownInfluence.Add(key);
                    }
                    else
                    {
                        dtUpdate.Rows.Add(dr);
                    }

                   
                    
                       
                }

                CustomKey rewardKey;
                StringBuilder sql = new StringBuilder(1000);
                foreach (Influence influence in pUpdate.Influence)
                {
                    Int32 rewardNpcId = DBNPCs.GetNpcId(influence.NPCName.Value, locale);

                    if(rewardNpcId <= 0)
                    {
                        continue;
                    }

                    // Expirations keyed on ID and Career:
                    rewardKey = new CustomKey(influence.Id, pUpdate.Players[0].Career, pUpdate.ClientVersion.Value);
                    if (!DB.IsEntityExpired(sInfluenceRewardExpirations, rewardKey, Config.Instance.QuestExpiration, pUpdate.IsTrustedUser))
                    {
                        continue;
                    }
                    
                    SetInfluenceRewardQuery(influence.Id, rewardNpcId, pUpdate, influence, sql);                        
                    
                }

                SqlCommand cmd = pConn.CreateCommand();

                if (sql.Length > 0)
                {
                    cmd.CommandText = sql.ToString();
                    cmd.ExecuteNonQuery();                    
                }
            

                // New Influence
                if (dtInsert.Rows.Count > 0)
                {

                    using (SqlBulkCopy bulk = new SqlBulkCopy(pConn,
                                                        SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                        null))
                    {
                        bulk.BatchSize = 5000;
                        bulk.DestinationTableName = "influence";
                        bulk.WriteToServer(dtInsert);                    
                    }
                    

                }
                
                // Influence Updates
                if (dtUpdate.Rows.Count > 0)
                {
                 
                    cmd.CommandText = "SELECT TOP 0 * INTO #influence FROM influence;";
                    cmd.ExecuteNonQuery();

                    using (SqlBulkCopy bulk = new SqlBulkCopy(pConn,
                                                         SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                         null))
                    {
                        bulk.BatchSize = 5000;
                        bulk.DestinationTableName = "#influence";
                        bulk.WriteToServer(dtUpdate);                    
                    }
                    
                    cmd.CommandText = String.Format(sUpdateQuery, locale);
                    cmd.ExecuteNonQuery();
                    cmd.CommandText = "DROP TABLE #influence;";
                    cmd.ExecuteNonQuery();
                }                                            
        }

    }
}